/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import org.snapscript.parse.SourceCode;
import org.snapscript.parse.SourceException;
import org.snapscript.parse.TextCategory;

public class SourceCompressor {
    private static final int LINE_LIMIT = 32000;
    private char[] original;
    private char[] compress;
    private short[] lines;
    private short line;
    private char space;
    private int write;
    private int read;
    private int count;

    public SourceCompressor(char[] original) {
        this.lines = new short[original.length];
        this.compress = new char[original.length];
        this.count = original.length;
        this.original = original;
        this.space = (char)32;
        this.line = 1;
    }

    public SourceCode compress() {
        if (this.read < this.count) {
            this.directive();
        }
        while (this.read < this.count) {
            char next = this.original[this.read];
            if (this.comment(next)) {
                if (this.comment()) continue;
                this.lines[this.write] = this.line;
                this.compress[this.write++] = this.original[this.read++];
                continue;
            }
            if (this.quote(next)) {
                if (this.string()) continue;
                this.lines[this.write] = this.line;
                this.compress[this.write++] = this.original[this.read++];
                continue;
            }
            if (!this.space(next)) {
                this.lines[this.write] = this.line;
                this.compress[this.write++] = this.original[this.read++];
                this.space = (char)32;
                continue;
            }
            if (this.write > 0 && this.read + 1 < this.count) {
                char before = this.compress[this.write - 1];
                char after = this.original[this.read + 1];
                if (this.identifier(before) && this.identifier(after)) {
                    this.lines[this.write] = this.line;
                    this.compress[this.write++] = this.space;
                } else if (this.operator(before) && this.operator(after)) {
                    this.lines[this.write] = this.line;
                    this.compress[this.write++] = this.space;
                }
            }
            if (next == '\n') {
                if (this.line > 32000) {
                    throw new SourceException("Source exceeds 32000 lines");
                }
                this.space = (char)10;
                this.line = (short)(this.line + 1);
            } else if (next == '\r') {
                this.space = (char)10;
            }
            ++this.read;
        }
        return this.create();
    }

    private SourceCode create() {
        char[] text = new char[this.write];
        short[] index = new short[this.write];
        short[] types = new short[this.write];
        if (this.write == 0) {
            throw new SourceException("Source text is empty");
        }
        for (int i = 0; i < this.write; ++i) {
            char next = this.compress[i];
            if (next < TextCategory.INDEX.length) {
                types[i] = TextCategory.INDEX[next];
            }
            index[i] = this.lines[i];
            text[i] = next;
        }
        return new SourceCode(this.original, text, index, types, this.line);
    }

    private boolean directive() {
        char next;
        char start = this.original[this.read];
        if (this.directive(start) && this.read + 1 < this.count && (next = this.original[this.read + 1]) == '!') {
            while (this.read < this.count) {
                char terminal = this.original[this.read];
                if (terminal == '\n') {
                    if (this.line > 32000) {
                        throw new SourceException("Source exceeds 32000 lines");
                    }
                    ++this.read;
                    this.line = (short)(this.line + 1);
                    return true;
                }
                ++this.read;
            }
            return true;
        }
        return false;
    }

    private boolean comment() {
        char start = this.original[this.read];
        if (this.comment(start) && this.read + 1 < this.count) {
            char next = this.original[this.read + 1];
            if (next == '/') {
                while (this.read < this.count) {
                    char terminal = this.original[this.read];
                    if (terminal == '\n') {
                        if (this.line > 32000) {
                            throw new SourceException("Source exceeds 32000 lines");
                        }
                        ++this.read;
                        this.line = (short)(this.line + 1);
                        return true;
                    }
                    ++this.read;
                }
                return true;
            }
            if (next == '*') {
                while (this.read < this.count) {
                    char prev;
                    char terminal = this.original[this.read];
                    if (terminal == '\n') {
                        if (this.line > 32000) {
                            throw new SourceException("Source exceeds 32000 lines");
                        }
                        this.line = (short)(this.line + 1);
                    }
                    if (terminal == '/' && this.read > 0 && (prev = this.original[this.read - 1]) == '*') {
                        ++this.read;
                        return true;
                    }
                    ++this.read;
                }
                throw new SourceException("Comment not closed at line " + this.line);
            }
        }
        return false;
    }

    private boolean string() {
        char start = this.original[this.read];
        if (this.quote(start)) {
            int size = 0;
            while (this.read < this.count) {
                char next = this.original[this.read];
                if (next == start) {
                    if (size == 1) {
                        this.lines[this.write] = this.line;
                        this.compress[this.write++] = this.original[this.read++];
                        return true;
                    }
                    if (this.read > 0 && size > 0) {
                        char prev = this.original[this.read - 1];
                        if (!this.escape(prev)) {
                            this.lines[this.write] = this.line;
                            this.compress[this.write++] = this.original[this.read++];
                            return true;
                        }
                        for (int i = 1; i <= size; ++i) {
                            char value = this.original[this.read - i];
                            if (this.escape(value)) continue;
                            if (i % 2 != 1) break;
                            this.lines[this.write] = this.line;
                            this.compress[this.write++] = this.original[this.read++];
                            return true;
                        }
                    }
                }
                if (next == '\n') {
                    if (this.line > 32000) {
                        throw new SourceException("Source exceeds 32000 lines");
                    }
                    this.line = (short)(this.line + 1);
                }
                this.lines[this.write] = this.line;
                this.compress[this.write++] = this.original[this.read++];
                ++size;
            }
            throw new SourceException("String literal not closed at line " + this.line);
        }
        return false;
    }

    private boolean escape(char value) {
        return value == '\\';
    }

    private boolean directive(char value) {
        return value == '#';
    }

    private boolean comment(char value) {
        return value == '/';
    }

    private boolean quote(char value) {
        switch (value) {
            case '\"': 
            case '\'': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    private boolean space(char value) {
        switch (value) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private boolean identifier(char value) {
        if (value >= 'a' && value <= 'z') {
            return true;
        }
        if (value >= 'A' && value <= 'Z') {
            return true;
        }
        return value >= '0' && value <= '9';
    }

    private boolean operator(char value) {
        switch (value) {
            case '%': 
            case '*': 
            case '+': 
            case '-': 
            case '/': {
                return true;
            }
        }
        return false;
    }
}

