/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import org.snapscript.parse.Grammar;
import org.snapscript.parse.GrammarCache;
import org.snapscript.parse.GrammarMatcher;
import org.snapscript.parse.Symbol;
import org.snapscript.parse.SyntaxBuilder;
import org.snapscript.parse.SyntaxChecker;
import org.snapscript.parse.TokenType;

public class SymbolGrammar
implements Grammar {
    private final GrammarMatcher matcher;

    public SymbolGrammar(Symbol symbol, String value, int index) {
        this.matcher = new SymbolMatcher(symbol, value, index);
    }

    @Override
    public GrammarMatcher create(GrammarCache cache, int length) {
        return this.matcher;
    }

    private static class SymbolMatcher
    implements GrammarMatcher {
        private final TokenType type;
        private final Symbol symbol;
        private final String value;
        private final int index;

        public SymbolMatcher(Symbol symbol, String value, int index) {
            this.type = symbol.type;
            this.symbol = symbol;
            this.value = value;
            this.index = index;
        }

        @Override
        public boolean check(SyntaxChecker checker, int depth) {
            int mask = checker.peek();
            if ((mask & this.type.mask) != 0) {
                int mark = checker.mark(this.index);
                if (this.symbol.read(checker)) {
                    checker.commit(mark, this.index);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean build(SyntaxBuilder builder, int depth) {
            SyntaxBuilder child;
            int mask = builder.peek();
            if ((mask & this.type.mask) != 0 && this.symbol.read(child = builder.mark(this.index))) {
                child.commit();
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format("[%s]", this.value);
        }
    }
}

