/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import java.util.LinkedHashMap;
import java.util.Map;
import org.snapscript.parse.Grammar;
import org.snapscript.parse.GrammarCompiler;
import org.snapscript.parse.GrammarDefinition;
import org.snapscript.parse.GrammarIndexer;
import org.snapscript.parse.GrammarReader;
import org.snapscript.parse.GrammarResolver;
import org.snapscript.parse.SyntaxParser;

public class SyntaxCompiler {
    private final Iterable<GrammarDefinition> definitions;
    private final Map<String, Grammar> grammars = new LinkedHashMap<String, Grammar>();
    private final GrammarCompiler compiler;
    private final GrammarResolver resolver = new GrammarResolver(this.grammars);
    private final GrammarIndexer indexer = new GrammarIndexer();
    private final SyntaxParser parser = new SyntaxParser(this.resolver, this.indexer);

    public SyntaxCompiler(String file) {
        this.compiler = new GrammarCompiler(this.resolver, this.indexer);
        this.definitions = new GrammarReader(file);
    }

    public synchronized SyntaxParser compile() {
        if (this.grammars.isEmpty()) {
            for (GrammarDefinition definition : this.definitions) {
                String name = definition.getName();
                String value = definition.getDefinition();
                Grammar grammar = this.compiler.process(name, value);
                this.grammars.put(name, grammar);
            }
        }
        return this.parser;
    }
}

