/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import org.snapscript.parse.GrammarIndexer;
import org.snapscript.parse.ParseException;
import org.snapscript.parse.SourceCode;
import org.snapscript.parse.SourceProcessor;
import org.snapscript.parse.SyntaxTree;

public class SyntaxTreeBuilder {
    private final SourceProcessor processor = new SourceProcessor(100);
    private final GrammarIndexer indexer;

    public SyntaxTreeBuilder(GrammarIndexer indexer) {
        this.indexer = indexer;
    }

    public SyntaxTree create(String resource, String text, String grammar) {
        char[] array = text.toCharArray();
        if (array.length == 0) {
            throw new ParseException("Source text is empty for '" + resource + "'");
        }
        SourceCode source = this.processor.process(text);
        char[] original = source.getOriginal();
        char[] compress = source.getSource();
        short[] lines = source.getLines();
        short[] types = source.getTypes();
        int count = source.getCount();
        return new SyntaxTree(this.indexer, resource, grammar, original, compress, lines, types, count);
    }
}

