/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.platform;

import org.snapscript.common.Cache;
import org.snapscript.core.type.Type;
import org.snapscript.platform.InvocationCache;
import org.snapscript.platform.InvocationCacheArray;

public class InvocationCacheTable<T> {
    private volatile InvocationCacheArray array;
    private volatile CacheAllocator allocator;

    public InvocationCacheTable(Class<? extends Cache> internal) {
        this(internal, 32);
    }

    public InvocationCacheTable(Class<? extends Cache> internal, int capacity) {
        this.array = new InvocationCacheArray(capacity, capacity);
        this.allocator = new CacheAllocator(internal);
    }

    public InvocationCache get(Type type) {
        int length;
        int index = type.getOrder();
        if (index >= (length = this.array.length())) {
            return this.allocator.allocate(type);
        }
        InvocationCache cache = this.array.get(index);
        if (cache == null) {
            return this.allocator.allocate(type);
        }
        return cache;
    }

    private class CacheAllocator {
        private final Class<? extends Cache> internal;

        public CacheAllocator(Class<? extends Cache> internal) {
            this.internal = internal;
        }

        public synchronized InvocationCache allocate(Type type) {
            int index = type.getOrder();
            InvocationCacheArray local = InvocationCacheTable.this.array.copy(index);
            InvocationCache cache = local.get(index);
            if (cache == null) {
                cache = new InvocationCache(this.internal);
                local.set(index, cache);
                InvocationCacheTable.this.array = local;
            }
            return cache;
        }
    }
}

