/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.platform;

import java.lang.reflect.Method;
import org.snapscript.core.Context;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.index.FunctionIndexer;
import org.snapscript.core.function.index.FunctionPointer;
import org.snapscript.core.function.resolve.FunctionCall;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.module.Module;
import org.snapscript.core.platform.Bridge;
import org.snapscript.core.platform.Platform;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.ScopeBinder;
import org.snapscript.core.scope.instance.Instance;
import org.snapscript.core.type.Type;
import org.snapscript.platform.MethodComparator;

public class InvocationRouter {
    private final MethodComparator comparator = new MethodComparator();
    private final FunctionIndexer indexer;
    private final ScopeBinder binder = new ScopeBinder();
    private final Platform builder;

    public InvocationRouter(Platform builder, FunctionIndexer indexer) {
        this.indexer = indexer;
        this.builder = builder;
    }

    public Object route(Bridge bridge, Method method, Object[] list) throws Throwable {
        Instance instance = (Instance)bridge.getInstance();
        Class<?> owner = method.getDeclaringClass();
        Scope scope = this.binder.bind(instance, instance);
        if (owner != Bridge.class) {
            Invocation invocation = this.bind(bridge, instance, method, list);
            Object value = invocation.invoke(scope, bridge, list);
            Module module = scope.getModule();
            Context context = module.getContext();
            ProxyWrapper wrapper = context.getWrapper();
            Class<?> returns = method.getReturnType();
            if (returns != Void.TYPE) {
                return wrapper.toProxy(value, returns);
            }
            return null;
        }
        return scope;
    }

    private Invocation bind(Bridge bridge, Instance instance, Method method, Object[] list) throws Throwable {
        String name = method.getName();
        Type type = instance.getType();
        Scope scope = this.binder.bind(instance, instance);
        FunctionPointer match = this.indexer.index(type, name, list);
        if (this.comparator.isAbstract(match)) {
            throw new InternalStateException("No implementaton of " + method + " for '" + type + "'");
        }
        if (this.comparator.isEqual(match, method)) {
            return this.builder.createSuperMethod(type, method);
        }
        Module module = scope.getModule();
        Context context = module.getContext();
        FunctionResolver resolver = context.getResolver();
        FunctionCall call = resolver.resolveInstance(scope, scope, name, list);
        if (call == null) {
            return this.builder.createSuperMethod(type, method);
        }
        return new CallableInvocation(call);
    }

    private static class CallableInvocation
    implements Invocation {
        private final FunctionCall call;

        public CallableInvocation(FunctionCall call) {
            this.call = call;
        }

        public Object invoke(Scope scope, Object object, Object ... list) throws Exception {
            return this.call.invoke(scope, scope, list);
        }
    }
}

