/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.platform;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.snapscript.core.platform.Bridge;
import org.snapscript.platform.InvocationRouter;
import org.snapscript.platform.generate.BridgeInstance;

public class ThreadLocalHandler
implements InvocationHandler {
    private final ThreadLocal<BridgeInstance> local;
    private final InvocationRouter router;

    public ThreadLocalHandler(ThreadLocal<BridgeInstance> local, InvocationRouter router) {
        this.router = router;
        this.local = local;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] list) throws Throwable {
        Bridge bridge = (Bridge)proxy;
        BridgeInstance instance = (BridgeInstance)bridge.getInstance();
        if (instance == null) {
            instance = this.local.get();
            if (instance == null) {
                throw new IllegalStateException("Object has not been constructed");
            }
            bridge.setInstance(instance);
        }
        instance.getHolder().setBridge(bridge);
        return this.router.route(bridge, method, list);
    }
}

