/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.platform.android;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.snapscript.common.Cache;
import org.snapscript.common.IdentityCache;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.type.Type;
import org.snapscript.platform.InvocationCache;
import org.snapscript.platform.InvocationCacheTable;
import org.snapscript.platform.android.ProxyClassLoader;
import org.snapscript.platform.android.ProxyInvocationBuilder;

public class ProxyInvocationResolver {
    private final Cache<Object, Invocation> adapters;
    private final ProxyInvocationBuilder builder;
    private final InvocationCacheTable table = new InvocationCacheTable(IdentityCache.class);

    public ProxyInvocationResolver(ProxyClassLoader generator) {
        this.adapters = new IdentityCache<Object, Invocation>();
        this.builder = new ProxyInvocationBuilder(generator);
    }

    public Invocation resolveSuperMethod(Type real, Method method) {
        InvocationCache cache = this.table.get(real);
        Invocation invocation = cache.fetch(method);
        if (invocation == null) {
            invocation = this.builder.createSuperMethod(method);
            cache.cache(method, invocation);
        }
        return invocation;
    }

    public Invocation resolveMethod(Method method) {
        Invocation invocation = this.adapters.fetch(method);
        if (invocation == null) {
            invocation = this.builder.createMethod(method);
            this.adapters.cache(method, invocation);
        }
        return invocation;
    }

    public Invocation resolveConstructor(Constructor constructor) {
        Invocation invocation = this.adapters.fetch(constructor);
        if (invocation == null) {
            invocation = this.builder.createConstructor(constructor);
            this.adapters.cache(constructor, invocation);
        }
        return invocation;
    }
}

