/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.platform.android;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.scope.Scope;
import org.snapscript.dx.stock.ProxyAdapter;
import org.snapscript.platform.android.InternalClassFilter;
import org.snapscript.platform.android.ProxyAdapterBuilder;

public class ProxyMethodInvocation
implements Invocation {
    private volatile MethodExchanger exchanger;
    private volatile ProxyAdapter reference;
    private volatile Executor executor;
    private volatile Method method;

    public ProxyMethodInvocation(ProxyAdapterBuilder generator, Method method, Executor executor) {
        this.exchanger = new MethodExchanger(generator, method);
        this.reference = new MethodAdapter(method);
        this.executor = executor;
        this.method = method;
    }

    public Object invoke(Scope scope, Object value, Object ... arguments) throws Exception {
        try {
            return this.reference.invoke(value, arguments);
        }
        catch (InvocationTargetException cause) {
            Throwable target = cause.getTargetException();
            if (target != null) {
                throw new InternalStateException("Error occured invoking " + this.method, target);
            }
            throw cause;
        }
        catch (InternalError cause) {
            Throwable target = cause.getCause();
            if (target != null) {
                throw new InternalStateException("Error occured invoking " + this.method, target);
            }
            throw cause;
        }
    }

    private class MethodExchanger
    implements Runnable {
        private final ProxyAdapterBuilder generator;
        private final InternalClassFilter filter = new InternalClassFilter();
        private final Method method;

        public MethodExchanger(ProxyAdapterBuilder generator, Method method) {
            this.generator = generator;
            this.method = method;
        }

        @Override
        public void run() {
            ProxyAdapter adapter;
            if (this.filter.accept(this.method) && (adapter = this.generator.generate(this.method)) != null) {
                ProxyMethodInvocation.this.reference = adapter;
            }
        }
    }

    private class MethodAdapter
    implements ProxyAdapter {
        private final AtomicLong counter;
        private final Method method;

        public MethodAdapter(Method method) {
            this(method, 10);
        }

        public MethodAdapter(Method method, int threshold) {
            this.counter = new AtomicLong(threshold);
            this.method = method;
        }

        @Override
        public Object invoke(Object object, Object ... list) throws Exception {
            long count = this.counter.getAndDecrement();
            if (count == 0L) {
                ProxyMethodInvocation.this.executor.execute(ProxyMethodInvocation.this.exchanger);
            }
            return this.method.invoke(object, list);
        }
    }
}

