/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.platform.generate;

import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.index.FunctionIndexer;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.platform.generate.BridgeInstance;
import org.snapscript.platform.generate.BridgeInstanceBuilder;
import org.snapscript.platform.generate.BridgeInstanceConverter;
import org.snapscript.platform.generate.ClassGenerator;

public class BridgeConstructorBuilder {
    private final BridgeInstanceConverter converter;
    private final BridgeInstanceBuilder builder;
    private final ThreadLocal local;

    public BridgeConstructorBuilder(ClassGenerator generator, FunctionIndexer indexer, ProxyWrapper wrapper, ThreadLocal local) {
        this.builder = new BridgeInstanceBuilder(generator, indexer);
        this.converter = new BridgeInstanceConverter(wrapper);
        this.local = local;
    }

    public Invocation createSuperConstructor(Type real, Type base) {
        return new BridgeInvocation(real, base);
    }

    private class BridgeInvocation
    implements Invocation {
        private final Type real;
        private final Type base;

        public BridgeInvocation(Type real, Type base) {
            this.real = real;
            this.base = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Scope scope, Object object, Object ... list) throws Exception {
            BridgeInstance instance = BridgeConstructorBuilder.this.builder.createInstance(this.real, this.base, list);
            try {
                BridgeConstructorBuilder.this.converter.convert(instance);
                BridgeConstructorBuilder.this.local.set(instance);
                instance.getBridge().setInstance(instance);
            }
            finally {
                BridgeConstructorBuilder.this.local.set(null);
            }
            return instance;
        }
    }
}

