/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.platform.generate;

import java.util.List;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.property.Property;
import org.snapscript.core.scope.State;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;
import org.snapscript.platform.generate.BridgeInstance;
import org.snapscript.platform.generate.BridgeValue;

public class BridgeInstanceConverter {
    private final ProxyWrapper wrapper;

    public BridgeInstanceConverter(ProxyWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void convert(BridgeInstance instance) {
        Type base = instance.getBase();
        Value self = Value.getReference(instance);
        List<Constraint> types = base.getTypes();
        State state = instance.getState();
        this.update(instance, state, base);
        for (Constraint type : types) {
            Type match = type.getType(instance);
            if (match == null) continue;
            this.update(instance, state, match);
        }
        state.addValue("this", self);
    }

    private void update(BridgeInstance instance, State state, Type type) {
        List<Property> properties = type.getProperties();
        for (Property property : properties) {
            Value current;
            String name = property.getName();
            if (name.equals("this") || (current = state.getValue(name)) != null) continue;
            BridgeValue value = new BridgeValue(instance, this.wrapper, property, name);
            state.addValue(name, value);
        }
    }
}

