/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.platform.generate;

import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.platform.Bridge;
import org.snapscript.core.property.Property;
import org.snapscript.core.variable.Value;
import org.snapscript.platform.generate.BridgeHolder;
import org.snapscript.platform.generate.BridgeInstance;

public class BridgeValue
extends Value {
    private final BridgeInstance instance;
    private final ProxyWrapper wrapper;
    private final Property property;
    private final String name;

    public BridgeValue(BridgeInstance instance, ProxyWrapper wrapper, Property property, String name) {
        this.instance = instance;
        this.property = property;
        this.wrapper = wrapper;
        this.name = name;
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public <T> T getValue() {
        try {
            BridgeHolder holder = this.instance.getHolder();
            Bridge bridge = holder.getBridge();
            Object object = this.property.getValue(bridge);
            return (T)this.wrapper.fromProxy(object);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get '" + this.name + "'", e);
        }
    }

    @Override
    public void setValue(Object value) {
        try {
            BridgeHolder holder = this.instance.getHolder();
            Bridge bridge = holder.getBridge();
            Object proxy = this.wrapper.toProxy(value);
            this.property.setValue(bridge, proxy);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not set '" + this.name + "'", e);
        }
    }

    @Override
    public int getModifiers() {
        return this.property.getModifiers();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.property);
    }
}

