/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.platform.standard;

import org.snapscript.cglib.proxy.Callback;
import org.snapscript.cglib.proxy.Enhancer;
import org.snapscript.cglib.proxy.MethodInterceptor;
import org.snapscript.core.Any;
import org.snapscript.core.ContextClassLoader;
import org.snapscript.core.EntityCache;
import org.snapscript.core.convert.InterfaceCollector;
import org.snapscript.core.platform.Bridge;
import org.snapscript.core.type.Type;
import org.snapscript.platform.generate.ClassGenerator;

public class EnhancerGenerator
implements ClassGenerator {
    private final InterfaceCollector collector;
    private final EntityCache<Class> cache;
    private final Callback[] interceptors;
    private final ClassLoader loader;

    public EnhancerGenerator(MethodInterceptor interceptor) {
        this.interceptors = new Callback[]{interceptor};
        this.loader = new ContextClassLoader(Any.class);
        this.collector = new InterfaceCollector(new Class[0]);
        this.cache = new EntityCache();
    }

    @Override
    public Class generate(Type type, Class base) {
        Class proxy = this.cache.fetch(type);
        if (proxy == null) {
            proxy = this.create(type, base);
            Enhancer.registerCallbacks(proxy, this.interceptors);
            this.cache.cache(type, proxy);
        }
        return proxy;
    }

    private Class create(Type type, Class base) {
        Class[] interfaces = this.collector.collect(type);
        try {
            Enhancer enhancer = new Enhancer();
            Class[] types = new Class[]{MethodInterceptor.class};
            enhancer.setClassLoader(this.loader);
            enhancer.setSuperclass(base);
            enhancer.setInterceptDuringConstruction(true);
            enhancer.setBeanInterfaces(Bridge.class);
            enhancer.setInterfaces(interfaces);
            enhancer.setCallbackTypes(types);
            return enhancer.createClass();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create proxy for " + type, e);
        }
    }
}

