/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.platform.standard;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.type.Type;
import org.snapscript.platform.InvocationCache;
import org.snapscript.platform.InvocationCacheTable;
import org.snapscript.platform.standard.DelegateConstructorInvocation;
import org.snapscript.platform.standard.DelegateMethodInvocation;
import org.snapscript.platform.standard.MethodProxyBuilder;

public class MethodInvocationResolver {
    private final InvocationCacheTable table = new InvocationCacheTable(CopyOnWriteCache.class);
    private final MethodProxyBuilder builder = new MethodProxyBuilder();

    public Invocation resolveSuperMethod(Type real, Method method) {
        InvocationCache cache = this.table.get(real);
        Invocation invocation = cache.fetch(method);
        if (invocation == null) {
            invocation = this.builder.createSuperMethod(method);
            cache.cache(method, invocation);
        }
        return invocation;
    }

    public Invocation resolveMethod(Method method) {
        return new DelegateMethodInvocation(method);
    }

    public Invocation resolveConstructor(Constructor constructor) {
        return new DelegateConstructorInvocation(constructor);
    }
}

