/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.platform.standard;

import org.snapscript.cglib.core.Signature;
import org.snapscript.cglib.proxy.MethodProxy;
import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.scope.Scope;

public class MethodProxySuperInvocation
implements Invocation {
    private final Cache<Class, MethodProxy> cache = new CopyOnWriteCache<Class, MethodProxy>();
    private final Signature signature;

    public MethodProxySuperInvocation(Signature signature) {
        this.signature = signature;
    }

    public Object invoke(Scope scope, Object value, Object ... arguments) {
        try {
            Class<?> type = value.getClass();
            MethodProxy proxy = this.cache.fetch(type);
            if (proxy == null) {
                proxy = MethodProxy.find(type, this.signature);
                this.cache.cache(type, proxy);
            }
            return proxy.invokeSuper(value, arguments);
        }
        catch (Throwable e) {
            throw new InternalStateException("Could not invoke " + this.signature, e);
        }
    }
}

