/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.platform.standard;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.index.FunctionIndexer;
import org.snapscript.core.platform.Platform;
import org.snapscript.core.type.Type;
import org.snapscript.platform.InvocationRouter;
import org.snapscript.platform.generate.BridgeConstructorBuilder;
import org.snapscript.platform.standard.EnhancerGenerator;
import org.snapscript.platform.standard.MethodInterceptorHandler;
import org.snapscript.platform.standard.MethodInvocationResolver;

public class StandardPlatform
implements Platform {
    private final MethodInvocationResolver resolver;
    private final MethodInterceptorHandler handler;
    private final BridgeConstructorBuilder builder;
    private final EnhancerGenerator generator;
    private final InvocationRouter router;
    private final ThreadLocal local;

    public StandardPlatform(FunctionIndexer indexer, ProxyWrapper wrapper) {
        this.router = new InvocationRouter(this, indexer);
        this.local = new ThreadLocal();
        this.handler = new MethodInterceptorHandler(this.local, this.router);
        this.generator = new EnhancerGenerator(this.handler);
        this.builder = new BridgeConstructorBuilder(this.generator, indexer, wrapper, this.local);
        this.resolver = new MethodInvocationResolver();
    }

    @Override
    public Invocation createSuperConstructor(Type real, Type base) {
        try {
            return this.builder.createSuperConstructor(real, base);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create super for '" + real + "'", e);
        }
    }

    @Override
    public Invocation createSuperMethod(Type real, Method method) {
        try {
            return this.resolver.resolveSuperMethod(real, method);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not call super for '" + method + "'", e);
        }
    }

    @Override
    public Invocation createMethod(Type real, Method method) {
        try {
            return this.resolver.resolveMethod(method);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create invocation for '" + method + "'", e);
        }
    }

    @Override
    public Invocation createConstructor(Type real, Constructor constructor) {
        try {
            return this.resolver.resolveConstructor(constructor);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create invocation for '" + constructor + "'", e);
        }
    }
}

