/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent;

import java.net.URI;
import org.snapscript.core.scope.EmptyModel;
import org.snapscript.core.scope.Model;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.studio.agent.ProcessAgentController;
import org.snapscript.studio.agent.ProcessClient;
import org.snapscript.studio.agent.ProcessContext;
import org.snapscript.studio.agent.ProcessMode;
import org.snapscript.studio.agent.client.ConnectTunnelClient;
import org.snapscript.studio.agent.client.ConnectionChecker;
import org.snapscript.studio.agent.client.ConnectionListener;
import org.snapscript.studio.agent.core.CompileValidator;
import org.snapscript.studio.agent.debug.BreakpointMatcher;
import org.snapscript.studio.agent.debug.FaultContextExtractor;
import org.snapscript.studio.agent.debug.ResumeType;
import org.snapscript.studio.agent.debug.SuspendController;
import org.snapscript.studio.agent.debug.SuspendInterceptor;
import org.snapscript.studio.agent.event.ProcessEventChannel;
import org.snapscript.studio.agent.event.ProcessEventTimer;
import org.snapscript.studio.agent.event.RegisterEvent;
import org.snapscript.studio.agent.log.AsyncLog;
import org.snapscript.studio.agent.log.ConsoleLog;
import org.snapscript.studio.agent.log.Log;
import org.snapscript.studio.agent.log.LogLevel;
import org.snapscript.studio.agent.log.LogLogger;
import org.snapscript.studio.agent.profiler.TraceProfiler;
import org.snapscript.studio.agent.task.ProcessExecutor;

public class ProcessAgent {
    private final ProcessContext context;
    private final LogLevel level;
    private final Model model = new EmptyModel();
    private final Log log = new ConsoleLog();

    public ProcessAgent(ProcessContext context, LogLevel level) {
        this.context = context;
        this.level = level;
    }

    public ProcessClient start(URI root, Runnable task) throws Exception {
        return this.start(root, task, this.model);
    }

    public ProcessClient start(URI root, Runnable task, Model model) throws Exception {
        return this.start(root, task, model, this.log);
    }

    public ProcessClient start(URI root, final Runnable task, Model model, Log log) throws Exception {
        BreakpointMatcher matcher = this.context.getMatcher();
        final SuspendController controller = this.context.getController();
        final TraceInterceptor interceptor = this.context.getInterceptor();
        final TraceProfiler profiler = this.context.getProfiler();
        String process = this.context.getProcess();
        String system = this.context.getSystem();
        ProcessMode mode = this.context.getMode();
        String host = root.getHost();
        int port = root.getPort();
        try {
            final AsyncLog adapter = new AsyncLog(log, this.level);
            final LogLogger logger = new LogLogger(adapter, this.level);
            CompileValidator validator = new CompileValidator(this.context);
            final ConnectionChecker checker = new ConnectionChecker(this.context, process, system);
            ProcessExecutor executor = new ProcessExecutor(this.context, checker, logger, mode, model);
            ProcessAgentController listener = new ProcessAgentController(this.context, checker, executor);
            ProcessEventTimer timer = new ProcessEventTimer(listener, logger);
            ConnectTunnelClient client = new ConnectTunnelClient(timer, checker, logger);
            final ProcessEventChannel channel = client.connect(process, host, port);
            final SuspendInterceptor suspender = new SuspendInterceptor(channel, matcher, controller, mode, process);
            final FaultContextExtractor extractor = new FaultContextExtractor(channel, logger, process);
            RegisterEvent register = new RegisterEvent.Builder(process).withSystem(system).build();
            interceptor.register(profiler);
            interceptor.register(suspender);
            interceptor.register(extractor);
            channel.send(register);
            validator.validate();
            checker.register(new ConnectionListener(){

                @Override
                public void onClose() {
                    try {
                        adapter.stop();
                        checker.close();
                        controller.resume(ResumeType.RUN);
                        interceptor.remove(profiler);
                        interceptor.remove(suspender);
                        interceptor.remove(extractor);
                        controller.resume(ResumeType.RUN);
                        channel.close("Stop requested");
                    }
                    catch (Exception e) {
                        logger.info("Error stopping client", e);
                    }
                    finally {
                        try {
                            task.run();
                        }
                        catch (Exception e) {
                            logger.info("Error executing completion task", e);
                        }
                    }
                }
            });
            checker.start();
            return new ProcessClient(this.context, channel, executor, process);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start process '" + process + "'", e);
        }
    }
}

