/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.snapscript.core.ResourceManager;
import org.snapscript.studio.agent.ProcessContext;
import org.snapscript.studio.agent.ProcessStore;
import org.snapscript.studio.agent.core.ExecuteLatch;
import org.snapscript.studio.agent.core.ExecuteStatus;
import org.snapscript.studio.agent.debug.BreakpointMatcher;
import org.snapscript.studio.agent.event.ExitEvent;
import org.snapscript.studio.agent.event.ProcessEventChannel;
import org.snapscript.studio.agent.task.ProcessExecutor;
import org.snapscript.studio.agent.worker.store.WorkerStore;

public class ProcessClient {
    private final Map<String, Map<Integer, Boolean>> breakpoints = new HashMap<String, Map<Integer, Boolean>>();
    private final ProcessEventChannel client;
    private final ProcessExecutor executor;
    private final ProcessContext context;
    private final String process;

    public ProcessClient(ProcessContext context, ProcessEventChannel client, ProcessExecutor executor, String process) {
        this.executor = executor;
        this.client = client;
        this.context = context;
        this.process = process;
    }

    public String loadScript(String project, String resource) {
        ResourceManager manager = this.context.getManager();
        String path = WorkerStore.getPath(project, resource);
        return manager.getString(path);
    }

    public void createBreakpoint(String resource, int line) {
        Map<Integer, Boolean> lines = this.breakpoints.get(resource);
        BreakpointMatcher matcher = this.context.getMatcher();
        if (lines == null) {
            lines = new HashMap<Integer, Boolean>();
            this.breakpoints.put(resource, lines);
        }
        lines.put(line, Boolean.TRUE);
        matcher.update(this.breakpoints);
    }

    public void removeBreakpoint(String resource, int line) {
        Map<Integer, Boolean> lines = this.breakpoints.get(resource);
        BreakpointMatcher matcher = this.context.getMatcher();
        if (lines == null) {
            lines = new HashMap<Integer, Boolean>();
            this.breakpoints.put(resource, lines);
        }
        lines.put(line, Boolean.FALSE);
        matcher.update(this.breakpoints);
    }

    public void beginExecute(String project, String resource, String dependencies, List<String> arguments, boolean debug) {
        BreakpointMatcher matcher = this.context.getMatcher();
        ProcessStore store = this.context.getStore();
        matcher.update(this.breakpoints);
        store.update(project);
        this.executor.beginExecute(this.client, project, resource, dependencies, arguments, debug);
    }

    public void attachProcess(String project, String resource) {
        BreakpointMatcher matcher = this.context.getMatcher();
        ProcessStore store = this.context.getStore();
        matcher.update(this.breakpoints);
        store.update(project);
        this.executor.attachProcess(this.client, project, resource);
        matcher.suspend();
    }

    public boolean waitUntilFinish(long time) {
        ExecuteLatch latch = this.context.getLatch();
        try {
            latch.wait(ExecuteStatus.FINISHED, time);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean detachClient() {
        ExitEvent event = new ExitEvent.Builder(this.process).withDuration(0L).withMode(this.context.getMode()).build();
        try {
            ExecuteLatch latch = this.context.getLatch();
            latch.disconnect();
            this.client.send(event);
        }
        catch (Exception e) {
            return false;
        }
        try {
            this.client.close("Client detach");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

