/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent;

import java.util.concurrent.Executor;
import org.snapscript.common.thread.ThreadPool;
import org.snapscript.compile.ResourceCompiler;
import org.snapscript.compile.StoreContext;
import org.snapscript.core.Context;
import org.snapscript.core.ExpressionEvaluator;
import org.snapscript.core.ResourceManager;
import org.snapscript.core.link.PackageLinker;
import org.snapscript.core.scope.EmptyModel;
import org.snapscript.core.scope.Model;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.studio.agent.ProcessMode;
import org.snapscript.studio.agent.ProcessStore;
import org.snapscript.studio.agent.core.ExecuteLatch;
import org.snapscript.studio.agent.debug.BreakpointMatcher;
import org.snapscript.studio.agent.debug.SuspendController;
import org.snapscript.studio.agent.profiler.TraceProfiler;

public class ProcessContext {
    private final SuspendController controller;
    private final ResourceCompiler compiler;
    private final TraceProfiler profiler;
    private final BreakpointMatcher matcher;
    private final ExecuteLatch latch;
    private final ProcessStore store;
    private final ProcessMode mode;
    private final Executor executor;
    private final Context context;
    private final Model model;
    private final String process;
    private final String system;

    public ProcessContext(ProcessMode mode, ProcessStore store, String process, String system) {
        this(mode, store, process, system, 10);
    }

    public ProcessContext(ProcessMode mode, ProcessStore store, String process, String system, int threads) {
        this(mode, store, process, system, threads, 0);
    }

    public ProcessContext(ProcessMode mode, ProcessStore store, String process, String system, int threads, int stack) {
        this.executor = new ThreadPool(threads < 5 ? 5 : threads, stack);
        this.latch = new ExecuteLatch(process, system);
        this.context = new StoreContext(store, this.executor);
        this.compiler = new ResourceCompiler(this.context);
        this.controller = new SuspendController();
        this.matcher = new BreakpointMatcher();
        this.profiler = new TraceProfiler();
        this.model = new EmptyModel();
        this.process = process;
        this.system = system;
        this.store = store;
        this.mode = mode;
    }

    public ProcessMode getMode() {
        return this.mode;
    }

    public ExecuteLatch getLatch() {
        return this.latch;
    }

    public ResourceManager getManager() {
        return this.context.getManager();
    }

    public PackageLinker getLinker() {
        return this.context.getLinker();
    }

    public TraceInterceptor getInterceptor() {
        return this.context.getInterceptor();
    }

    public ResourceCompiler getCompiler() {
        return this.compiler;
    }

    public ExpressionEvaluator getEvaluator() {
        return this.context.getEvaluator();
    }

    public TraceProfiler getProfiler() {
        return this.profiler;
    }

    public BreakpointMatcher getMatcher() {
        return this.matcher;
    }

    public SuspendController getController() {
        return this.controller;
    }

    public ProcessStore getStore() {
        return this.store;
    }

    public Model getModel() {
        return this.model;
    }

    public String getSystem() {
        return this.system;
    }

    public String getProcess() {
        return this.process;
    }
}

