/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent;

public enum ProcessMode {
    REMOTE(false, false),
    SERVICE(false, false),
    SCRIPT(true, false),
    TASK(false, true);

    private final boolean terminate;
    private final boolean detach;

    private ProcessMode(boolean terminate, boolean detach) {
        this.terminate = terminate;
        this.detach = detach;
    }

    public boolean isRemoteAttachment() {
        return this == REMOTE;
    }

    public boolean isDetachRequired() {
        return this.detach;
    }

    public boolean isTerminateRequired() {
        return this.terminate;
    }

    public static ProcessMode resolveMode(String token) {
        ProcessMode[] modes;
        for (ProcessMode mode : modes = ProcessMode.values()) {
            String name = mode.name();
            if (!name.equalsIgnoreCase(token)) continue;
            return mode;
        }
        return SCRIPT;
    }
}

