/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.cli;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.snapscript.studio.agent.cli.CommandLine;
import org.snapscript.studio.agent.cli.CommandOption;
import org.snapscript.studio.agent.cli.CommandOptionParser;
import org.snapscript.studio.agent.cli.CommandValue;

public class CommandLineBuilder {
    private final List<? extends CommandOption> options;
    private final CommandOptionParser parser;

    public CommandLineBuilder(List<? extends CommandOption> options) {
        this.parser = new CommandOptionParser(options);
        this.options = options;
    }

    public CommandLine build(String[] arguments) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ArrayList<String> values = new ArrayList<String>();
        HashSet<String> done = new HashSet<String>();
        for (CommandOption commandOption : this.options) {
            String name = commandOption.getName();
            String code = commandOption.getCode();
            if (!done.add(name)) {
                throw new IllegalStateException("Option '" + name + "' declared twice");
            }
            if (done.add(code)) continue;
            throw new IllegalStateException("Option '" + code + "' declared twice");
        }
        for (String argument : arguments) {
            if (argument.startsWith("--")) {
                CommandValue value = this.parser.parse(argument);
                Object object = value.getValue();
                String name = value.getName();
                map.put(name, object);
                continue;
            }
            values.add(argument);
        }
        for (CommandOption commandOption : this.options) {
            Object token;
            String name = commandOption.getName();
            if (map.containsKey(name) || (token = commandOption.getDefault()) == null) continue;
            Class type = commandOption.getType();
            Object value = this.parser.convert(token, type);
            map.put(name, value);
        }
        String[] remainder = values.toArray(new String[0]);
        return new CommandLine(this.options, map, remainder);
    }
}

