/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.snapscript.studio.agent.cli.CommandOption;

public class CommandLineUsage {
    public static void usage(List<? extends CommandOption> options, String warning) {
        StringWriter builder = new StringWriter();
        PrintWriter writer = new PrintWriter(builder);
        if (warning != null) {
            writer.println(warning);
            writer.println();
        }
        writer.println("Usage:");
        writer.println();
        int name = 0;
        int code = 0;
        int pad = 3;
        for (CommandOption commandOption : options) {
            if (commandOption.getCode().length() > code) {
                code = commandOption.getCode().length();
            }
            if (commandOption.getName().length() <= name) continue;
            name = commandOption.getName().length();
        }
        for (CommandOption commandOption : options) {
            int i;
            writer.print("--");
            writer.print(commandOption.getCode());
            for (i = commandOption.getCode().length(); i < code + pad; ++i) {
                writer.print(" ");
            }
            writer.print("--");
            writer.print(commandOption.getName());
            for (i = commandOption.getName().length(); i < name + pad; ++i) {
                writer.print(" ");
            }
            writer.print(commandOption.getDescription());
            writer.println();
        }
        writer.println();
        writer.flush();
        writer.close();
        System.err.println(builder);
        System.err.flush();
        System.exit(0);
    }
}

