/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.studio.agent.client.ConnectTunnelHandler;
import org.snapscript.studio.agent.client.ConnectionChecker;
import org.snapscript.studio.agent.core.QueueExecutor;
import org.snapscript.studio.agent.event.BeginEvent;
import org.snapscript.studio.agent.event.BreakpointsEvent;
import org.snapscript.studio.agent.event.BrowseEvent;
import org.snapscript.studio.agent.event.EvaluateEvent;
import org.snapscript.studio.agent.event.ExecuteEvent;
import org.snapscript.studio.agent.event.ExitEvent;
import org.snapscript.studio.agent.event.FaultEvent;
import org.snapscript.studio.agent.event.PingEvent;
import org.snapscript.studio.agent.event.PongEvent;
import org.snapscript.studio.agent.event.ProcessEvent;
import org.snapscript.studio.agent.event.ProcessEventChannel;
import org.snapscript.studio.agent.event.ProcessEventConnection;
import org.snapscript.studio.agent.event.ProcessEventConsumer;
import org.snapscript.studio.agent.event.ProcessEventListener;
import org.snapscript.studio.agent.event.ProcessEventProducer;
import org.snapscript.studio.agent.event.ProfileEvent;
import org.snapscript.studio.agent.event.RegisterEvent;
import org.snapscript.studio.agent.event.ScopeEvent;
import org.snapscript.studio.agent.event.ScriptErrorEvent;
import org.snapscript.studio.agent.event.StepEvent;
import org.snapscript.studio.agent.event.WriteErrorEvent;
import org.snapscript.studio.agent.event.WriteOutputEvent;
import org.snapscript.studio.agent.log.TraceLogger;

public class ConnectTunnelClient {
    private static final String THREAD_NAME = "%s: %s@%s:%s";
    private final ProcessEventListener listener;
    private final QueueExecutor executor = new QueueExecutor();
    private final ConnectionChecker checker;
    private final TraceLogger logger;

    public ConnectTunnelClient(ProcessEventListener listener, ConnectionChecker checker, TraceLogger logger) throws IOException {
        this.listener = listener;
        this.checker = checker;
        this.logger = logger;
    }

    public ProcessEventChannel connect(String process, String host, int port) throws Exception {
        String type = SocketConnection.class.getSimpleName();
        String name = String.format(THREAD_NAME, type, process, host, port);
        try {
            Socket socket = new Socket(host, port);
            ConnectTunnelHandler tunnel = new ConnectTunnelHandler(this.logger, process, port);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            SocketClientSession session = new SocketClientSession(this.checker, socket);
            SocketConnection connection = new SocketConnection(session, input, output);
            this.executor.start();
            connection.setName(name);
            tunnel.tunnel(socket);
            socket.setSoTimeout(10000);
            connection.start();
            return connection;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not connect to " + host + ":" + port, e);
        }
    }

    private class SocketConnection
    extends Thread
    implements ProcessEventChannel {
        private final ProcessEventConnection connection;
        private final SocketClientSession session;
        private final AtomicBoolean closed;
        private final Set<Class> events;

        public SocketConnection(SocketClientSession session, InputStream input, OutputStream output) throws IOException {
            this.connection = new ProcessEventConnection(ConnectTunnelClient.this.logger, ConnectTunnelClient.this.executor, input, output, session);
            this.events = new CopyOnWriteArraySet<Class>();
            this.closed = new AtomicBoolean();
            this.session = session;
        }

        @Override
        public boolean send(ProcessEvent event) throws Exception {
            ProcessEventProducer producer = this.connection.getProducer();
            String process = event.getProcess();
            try {
                producer.produce(event);
                return true;
            }
            catch (Exception e) {
                ConnectTunnelClient.this.logger.info(process + ": Error sending event", e);
                this.close(process + ": Error sending event " + event + ": " + e);
                return false;
            }
        }

        @Override
        public boolean sendAsync(ProcessEvent event) throws Exception {
            ProcessEventProducer producer = this.connection.getProducer();
            String process = event.getProcess();
            try {
                Future<Boolean> future = producer.produceAsync(event);
                return future.get();
            }
            catch (Exception e) {
                ConnectTunnelClient.this.logger.info(process + ": Error sending async event", e);
                this.close(process + ": Error sending async event " + event + ": " + e);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    ProcessEventConsumer consumer = this.connection.getConsumer();
                    while (true) {
                        ProcessEvent event = consumer.consume();
                        Class<?> type = event.getClass();
                        this.events.add(type);
                        if (event instanceof ExitEvent) {
                            ConnectTunnelClient.this.listener.onExit(this, (ExitEvent)event);
                            continue;
                        }
                        if (event instanceof ExecuteEvent) {
                            ConnectTunnelClient.this.listener.onExecute(this, (ExecuteEvent)event);
                            continue;
                        }
                        if (event instanceof RegisterEvent) {
                            ConnectTunnelClient.this.listener.onRegister(this, (RegisterEvent)event);
                            continue;
                        }
                        if (event instanceof ScriptErrorEvent) {
                            ConnectTunnelClient.this.listener.onScriptError(this, (ScriptErrorEvent)event);
                            continue;
                        }
                        if (event instanceof WriteErrorEvent) {
                            ConnectTunnelClient.this.listener.onWriteError(this, (WriteErrorEvent)event);
                            continue;
                        }
                        if (event instanceof WriteOutputEvent) {
                            ConnectTunnelClient.this.listener.onWriteOutput(this, (WriteOutputEvent)event);
                            continue;
                        }
                        if (event instanceof PingEvent) {
                            ConnectTunnelClient.this.listener.onPing(this, (PingEvent)event);
                            continue;
                        }
                        if (event instanceof PongEvent) {
                            ConnectTunnelClient.this.listener.onPong(this, (PongEvent)event);
                            continue;
                        }
                        if (event instanceof ScopeEvent) {
                            ConnectTunnelClient.this.listener.onScope(this, (ScopeEvent)event);
                            continue;
                        }
                        if (event instanceof BreakpointsEvent) {
                            ConnectTunnelClient.this.listener.onBreakpoints(this, (BreakpointsEvent)event);
                            continue;
                        }
                        if (event instanceof BeginEvent) {
                            ConnectTunnelClient.this.listener.onBegin(this, (BeginEvent)event);
                            continue;
                        }
                        if (event instanceof StepEvent) {
                            ConnectTunnelClient.this.listener.onStep(this, (StepEvent)event);
                            continue;
                        }
                        if (event instanceof BrowseEvent) {
                            ConnectTunnelClient.this.listener.onBrowse(this, (BrowseEvent)event);
                            continue;
                        }
                        if (event instanceof EvaluateEvent) {
                            ConnectTunnelClient.this.listener.onEvaluate(this, (EvaluateEvent)event);
                            continue;
                        }
                        if (event instanceof ProfileEvent) {
                            ConnectTunnelClient.this.listener.onProfile(this, (ProfileEvent)event);
                            continue;
                        }
                        if (!(event instanceof FaultEvent)) continue;
                        ConnectTunnelClient.this.listener.onFault(this, (FaultEvent)event);
                    }
                }
                catch (Exception e) {
                    ConnectTunnelClient.this.logger.info("Error processing events [" + this.events + "]", e);
                    this.close("Error in event loop: " + e);
                    this.close("Event loop has finished");
                }
            }
            catch (Throwable throwable) {
                this.close("Event loop has finished");
                throw throwable;
            }
        }

        @Override
        public void close(String reason) {
            try {
                ProcessEventProducer producer = this.connection.getProducer();
                if (this.closed.compareAndSet(false, true)) {
                    ConnectTunnelClient.this.listener.onClose(this);
                    producer.close(reason);
                }
                this.session.close();
            }
            catch (Exception e) {
                ConnectTunnelClient.this.logger.info("Error closing client connection", e);
            }
        }
    }

    private class SocketClientSession
    implements Closeable {
        private final ConnectionChecker checker;
        private final Socket socket;

        public SocketClientSession(ConnectionChecker checker, Socket socket) {
            this.checker = checker;
            this.socket = socket;
        }

        @Override
        public void close() {
            try {
                this.checker.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.socket.shutdownInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ConnectTunnelClient.this.executor.stop();
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

