/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.client;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.snapscript.studio.agent.log.TraceLogger;

public class ConnectTunnelHandler {
    private static final int[] TERMINAL = new int[]{13, 10, 13, 10};
    private static final String CHARSET = "UTF-8";
    private static final String FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final String TIME_ZONE = "GMT";
    private static final String REQUEST = "CONNECT %s:%s/connect/%s HTTP/1.1\r\nHost: %s:%s\r\nDate: %s\r\n\r\n";
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final TraceLogger logger;
    private final DateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    private final TimeZone zone = TimeZone.getTimeZone("GMT");
    private final String process;
    private final int connect;

    public ConnectTunnelHandler(TraceLogger logger, String process, int connect) {
        this.process = process;
        this.logger = logger;
        this.connect = connect;
    }

    public synchronized void tunnel(Socket socket) throws Exception {
        this.format.setTimeZone(this.zone);
        this.send(socket);
        this.receive(socket);
    }

    private synchronized void send(Socket socket) throws Exception {
        OutputStream output = socket.getOutputStream();
        InetAddress address = socket.getInetAddress();
        String host = address.getHostAddress();
        int port = socket.getPort();
        long time = System.currentTimeMillis();
        String date = this.format.format(time);
        String request = String.format(REQUEST, host, this.connect, this.process, host, port, date);
        byte[] header = request.getBytes(CHARSET);
        output.write(header);
        output.flush();
    }

    private synchronized void receive(Socket socket) throws Exception {
        InputStream input = socket.getInputStream();
        int seek = 0;
        do {
            int count;
            if ((count = input.read()) != TERMINAL[seek++]) {
                seek = 0;
            }
            this.buffer.write(count);
        } while (seek != TERMINAL.length);
        String header = this.buffer.toString(CHARSET);
        this.buffer.reset();
        this.logger.trace(header);
    }
}

