/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.client;

import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.snapscript.common.thread.ThreadBuilder;
import org.snapscript.studio.agent.ProcessContext;
import org.snapscript.studio.agent.ProcessMode;
import org.snapscript.studio.agent.client.ConnectionListener;
import org.snapscript.studio.agent.core.ExecuteData;
import org.snapscript.studio.agent.core.ExecuteLatch;
import org.snapscript.studio.agent.core.ExecuteState;
import org.snapscript.studio.agent.core.ExecuteStatus;
import org.snapscript.studio.agent.core.TerminateHandler;
import org.snapscript.studio.agent.event.PingEvent;
import org.snapscript.studio.agent.event.PongEvent;
import org.snapscript.studio.agent.event.ProcessEventChannel;
import org.snapscript.studio.agent.event.StatusEvent;

public class ConnectionChecker
implements Closeable {
    private final Set<ConnectionListener> listeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final ProcessContext context;
    private final ThreadFactory factory;
    private final HealthChecker checker;
    private final AtomicBoolean active = new AtomicBoolean();
    private final AtomicLong update = new AtomicLong();
    private final String process;
    private final String system;

    public ConnectionChecker(ProcessContext context, String process, String system) {
        this.checker = new HealthChecker(this, this.active, this.update, 10000L);
        this.factory = new ThreadBuilder();
        this.context = context;
        this.process = process;
        this.system = system;
    }

    public void register(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void remove(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public void update(ProcessEventChannel channel, PingEvent event) {
        block11: {
            ProcessMode mode = this.context.getMode();
            ExecuteLatch latch = this.context.getLatch();
            ExecuteState state = latch.getState();
            ExecuteStatus status = state.getStatus();
            ExecuteData data = state.getData();
            String project = data.getProject();
            String resource = data.getResource();
            long time = System.currentTimeMillis();
            try {
                StatusEvent pong = ((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)new PongEvent.Builder(this.process).withSystem(this.system)).withProject(project)).withResource(resource)).withStatus(status)).withTotalMemory(Runtime.getRuntime().totalMemory())).withUsedMemory(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())).withThreads(Thread.getAllStackTraces().size())).build();
                if (mode.isDetachRequired()) {
                    if (!status.isFinished()) {
                        if (!channel.send(pong)) {
                            if (mode.isTerminateRequired()) {
                                TerminateHandler.terminate("Ping failed for " + this.process);
                            }
                        } else {
                            this.update.set(time);
                        }
                    }
                } else if (!channel.send(pong)) {
                    if (mode.isTerminateRequired()) {
                        TerminateHandler.terminate("Ping failed for " + this.process);
                    }
                } else {
                    this.update.set(time);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!mode.isTerminateRequired()) break block11;
                TerminateHandler.terminate("Ping failed for " + this.process + " with " + e);
            }
        }
    }

    public void start() {
        if (this.active.compareAndSet(false, true)) {
            Thread thread = this.factory.newThread(this.checker);
            String type = HealthChecker.class.getSimpleName();
            String name = thread.getName();
            thread.setName(type + ": " + name);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.active.compareAndSet(true, false)) {
            for (ConnectionListener listener : this.listeners) {
                try {
                    listener.onClose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.listeners.remove(listener);
                }
            }
        }
    }

    private static class HealthChecker
    implements Runnable {
        private final ConnectionChecker checker;
        private final AtomicBoolean active;
        private final AtomicLong update;
        private final long frequency;

        public HealthChecker(ConnectionChecker checker, AtomicBoolean active, AtomicLong update, long frequency) {
            this.frequency = frequency;
            this.checker = checker;
            this.active = active;
            this.update = update;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.active.get()) {
                    Thread.sleep(this.frequency);
                    long last = this.update.get();
                    long time = System.currentTimeMillis();
                    long duration = time - last;
                    if (duration <= this.frequency) continue;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.checker.close();
            }
        }
    }
}

