/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.core;

import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class ClassPathUpdater {
    private static final String INCLUDE_MESSAGE = "Including %s in classpath";
    private static final String ADD_URL_METHOD = "addURL";
    private static final String JAR_EXTENSION = ".jar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> parseClassPath(String dependencies) throws Exception {
        StringReader source = new StringReader(dependencies);
        LineNumberReader reader = new LineNumberReader(source);
        ArrayList<File> files = new ArrayList<File>();
        try {
            String line = reader.readLine();
            while (line != null) {
                String token = line.trim();
                int length = token.length();
                if (length > 0 && !token.startsWith("#")) {
                    File file = new File(token);
                    files.add(file);
                }
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        return files;
    }

    public static ClassLoader updateClassPath(String dependencies) throws Exception {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (URLClassLoader.class.isInstance(loader)) {
            Method method = URLClassLoader.class.getDeclaredMethod(ADD_URL_METHOD, URL.class);
            List<File> files = ClassPathUpdater.parseClassPath(dependencies);
            int size = files.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    File file = files.get(i);
                    URI location = file.toURI();
                    URL path = location.toURL();
                    method.setAccessible(true);
                    method.invoke((Object)loader, path);
                }
            }
            return loader;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateClassPath(List<File> dependencies, boolean debug) throws Exception {
        URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod(ADD_URL_METHOD, URL.class);
        for (File dependency : dependencies) {
            String resource = dependency.getAbsolutePath();
            if (dependency.isFile() && !resource.endsWith(JAR_EXTENSION)) {
                FileReader source = new FileReader(dependency);
                LineNumberReader reader = new LineNumberReader(source);
                ArrayList<File> files = new ArrayList<File>();
                try {
                    File file;
                    String line = reader.readLine();
                    while (line != null) {
                        String token = line.trim();
                        int length = token.length();
                        if (length > 0) {
                            file = new File(token);
                            files.add(file);
                        }
                        line = reader.readLine();
                    }
                    int size = files.size();
                    if (size <= 0) continue;
                    for (int i = 0; i < size; ++i) {
                        file = ((File)files.get(i)).getCanonicalFile();
                        URI location = file.toURI();
                        URL path = location.toURL();
                        if (debug) {
                            String message = String.format(INCLUDE_MESSAGE, path);
                            System.err.println(message);
                        }
                        if (!file.exists()) {
                            throw new IllegalArgumentException("Could not find " + path);
                        }
                        method.setAccessible(true);
                        method.invoke((Object)loader, path);
                    }
                    continue;
                }
                finally {
                    reader.close();
                    continue;
                }
            }
            File file = dependency.getCanonicalFile();
            URI location = file.toURI();
            URL path = location.toURL();
            if (debug) {
                String message = String.format(INCLUDE_MESSAGE, path);
                System.err.println(message);
            }
            if (!file.exists()) {
                throw new IllegalArgumentException("Could not find " + path);
            }
            method.setAccessible(true);
            method.invoke((Object)loader, path);
        }
    }
}

