/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.core;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.common.LockProgress;
import org.snapscript.common.Progress;
import org.snapscript.studio.agent.core.ExecuteData;
import org.snapscript.studio.agent.core.ExecuteState;
import org.snapscript.studio.agent.core.ExecuteStatus;

public class ExecuteLatch {
    private static final long DEFAULT_DURATION = 86400000L;
    private final AtomicReference<ExecuteStatus> statusReference;
    private final AtomicReference<ExecuteData> executeReference;
    private final Progress<ExecuteStatus> progress;
    private final AtomicLong lastUpdate;
    private final ExecuteData waitData;
    private final ExecuteState state;
    private final long duration;

    public ExecuteLatch(String process, String system) {
        this(process, system, 86400000L);
    }

    public ExecuteLatch(String process, String system, long duration) {
        this.waitData = new ExecuteData(process, null, null, null, false);
        this.executeReference = new AtomicReference<ExecuteData>(this.waitData);
        this.statusReference = new AtomicReference<ExecuteStatus>(ExecuteStatus.WAITING);
        this.progress = new LockProgress<ExecuteStatus>();
        this.state = new StateReference(this, process, system);
        this.lastUpdate = new AtomicLong();
        this.duration = duration;
    }

    public ExecuteState getState() {
        return this.state;
    }

    public boolean start(ExecuteData startData) {
        ExecuteStatus current = this.statusReference.get();
        if (current.isTransitionForward(ExecuteStatus.STARTING)) {
            long thisTime = System.nanoTime();
            this.executeReference.set(startData);
            this.lastUpdate.set(thisTime);
            this.statusReference.set(ExecuteStatus.STARTING);
            this.progress.done(ExecuteStatus.STARTING);
            return true;
        }
        return false;
    }

    public long update(ExecuteStatus status) {
        ExecuteStatus current = this.statusReference.get();
        if (current.isTransitionForward(status)) {
            long thisTime = System.nanoTime();
            long previousTime = this.lastUpdate.get();
            long duration = TimeUnit.NANOSECONDS.toMillis(thisTime - previousTime);
            this.lastUpdate.set(thisTime);
            this.statusReference.set(status);
            this.progress.done(status);
            return duration;
        }
        return -1L;
    }

    public boolean done(ExecuteStatus status) {
        ExecuteStatus current = this.statusReference.get();
        return !current.isTransitionForward(status);
    }

    public void wait(ExecuteStatus status) {
        this.wait(status, this.duration);
    }

    public void wait(ExecuteStatus status, long duration) {
        ExecuteStatus current = this.statusReference.get();
        if (current.isTransitionForward(status) && duration > 0L) {
            this.progress.wait(status, duration);
        }
    }

    public void disconnect() {
        this.statusReference.getAndSet(ExecuteStatus.WAITING);
        this.executeReference.set(this.waitData);
    }

    private static class StateReference
    implements ExecuteState {
        private final ExecuteLatch latch;
        private final String system;
        private final String process;

        public StateReference(ExecuteLatch latch, String process, String system) {
            this.process = process;
            this.system = system;
            this.latch = latch;
        }

        @Override
        public ExecuteData getData() {
            return (ExecuteData)this.latch.executeReference.get();
        }

        @Override
        public ExecuteStatus getStatus() {
            return (ExecuteStatus)((Object)this.latch.statusReference.get());
        }

        @Override
        public String getProcess() {
            return this.process;
        }

        @Override
        public String getSystem() {
            return this.system;
        }
    }
}

