/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.core;

public enum ExecuteStatus {
    REGISTERING(false, false, false, 0),
    WAITING(false, false, false, 1),
    STARTING(false, false, true, 2),
    COMPILING(false, false, true, 3),
    DEBUGGING(true, true, true, 4),
    RUNNING(true, false, true, 4),
    TERMINATING(true, false, true, 5),
    FINISHED(false, false, true, 6);

    private final boolean running;
    private final boolean debug;
    private final boolean started;
    private final int phase;

    private ExecuteStatus(boolean running, boolean debug, boolean started, int phase) {
        this.started = started;
        this.running = running;
        this.debug = debug;
        this.phase = phase;
    }

    public boolean isFinished() {
        return this == FINISHED;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isTransitionForward(ExecuteStatus next) {
        return next.phase > this.phase;
    }

    public boolean isTransitionPossible(ExecuteStatus next) {
        return next.phase >= this.phase;
    }

    public static ExecuteStatus resolveStatus(String token) {
        if (token != null) {
            ExecuteStatus[] statuses;
            for (ExecuteStatus mode : statuses = ExecuteStatus.values()) {
                String name = mode.name();
                if (!name.equalsIgnoreCase(token)) continue;
                return mode;
            }
        }
        return WAITING;
    }
}

