/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.debug;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.snapscript.studio.agent.debug.ScopeNode;
import org.snapscript.studio.agent.debug.ScopeNodeBuilder;

public class ArrayScopeNode
implements ScopeNode {
    private final ScopeNodeBuilder builder;
    private final List<ScopeNode> nodes = new ArrayList<ScopeNode>();
    private final Object object;
    private final String name;
    private final String path;
    private final int depth;

    public ArrayScopeNode(ScopeNodeBuilder builder, Object object, String path, String name, int depth) {
        this.builder = builder;
        this.object = object;
        this.depth = depth;
        this.path = path;
        this.name = name;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<ScopeNode> getNodes() {
        int length;
        if (this.nodes.isEmpty() && (length = Array.getLength(this.object)) > 0) {
            for (int i = 0; i < length; ++i) {
                try {
                    ScopeNode node;
                    Object value = Array.get(this.object, i);
                    if (value == null || (node = this.builder.createNode(this.path + ".[" + i + "]", "[" + i + "]", value, 0, this.depth)) == null) continue;
                    this.nodes.add(node);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.nodes;
    }
}

