/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.debug;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.studio.agent.debug.ResourceExtractor;

public class BreakpointMatcher {
    private volatile AtomicBoolean suspend = new AtomicBoolean();
    private volatile Set[] matches = new Set[0];

    public void suspend() {
        this.suspend.set(true);
    }

    public void update(Map<String, Map<Integer, Boolean>> breakpoints) {
        Set[] copy = new Set[1024];
        if (breakpoints != null) {
            Set<String> resources = breakpoints.keySet();
            for (String resource : resources) {
                Map<Integer, Boolean> locations = breakpoints.get(resource);
                if (locations == null) continue;
                Set<Integer> lines = locations.keySet();
                for (Integer line : lines) {
                    HashSet<String> set;
                    Boolean enabled = locations.get(line);
                    if (enabled == null || !enabled.booleanValue()) continue;
                    if (line > copy.length) {
                        copy = this.copyOf(copy, line * 2);
                    }
                    if ((set = copy[line]) == null) {
                        copy[line.intValue()] = set = new HashSet<String>();
                    }
                    String module = ResourceExtractor.extractModule(resource);
                    set.add(module);
                    set.add(resource);
                }
            }
        }
        this.matches = copy;
    }

    public boolean isBreakpoint(String resource, int line) {
        Set set;
        if (line < this.matches.length && line >= 0 && (set = this.matches[line]) != null) {
            return set.contains(resource) || this.suspend.getAndSet(false);
        }
        return this.suspend.getAndSet(false);
    }

    private Set[] copyOf(Set[] array, int newSize) {
        Set[] copy = new Set[newSize];
        System.arraycopy(array, 0, copy, 0, Math.min(newSize, array.length));
        return copy;
    }
}

