/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.debug;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.snapscript.core.Context;
import org.snapscript.core.ExpressionEvaluator;
import org.snapscript.core.scope.Scope;

public class ExpressionProcessor {
    private static final Object NULL_VALUE = new Object();
    private final Map<String, Object> results = new ConcurrentHashMap<String, Object>();
    private final Context context;
    private final Scope scope;

    public ExpressionProcessor(Context context, Scope scope) {
        this.context = context;
        this.scope = scope;
    }

    public Object evaluate(String expression) {
        return this.evaluate(expression, false);
    }

    public Object evaluate(String expression, boolean refresh) {
        Object result;
        if (refresh) {
            this.results.clear();
        }
        if (!this.accept(expression)) {
            this.results.clear();
            return null;
        }
        if (!this.results.containsKey(expression)) {
            result = this.execute(expression);
            this.results.clear();
            this.results.put(expression, result);
        }
        if ((result = this.results.get(expression)) != NULL_VALUE) {
            return result;
        }
        return null;
    }

    private Object execute(String expression) {
        try {
            ExpressionEvaluator evaluator = this.context.getEvaluator();
            Object result = evaluator.evaluate(this.scope, expression);
            if (result == null) {
                return NULL_VALUE;
            }
            return result;
        }
        catch (Exception cause) {
            cause.printStackTrace();
            return cause;
        }
    }

    private boolean accept(String expression) {
        String token;
        int length;
        return expression != null && (length = (token = expression.trim()).length()) > 0;
    }
}

