/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.debug;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.snapscript.core.type.index.ModifierConverter;
import org.snapscript.studio.agent.debug.ScopeNode;
import org.snapscript.studio.agent.debug.ScopeNodeBuilder;

public class ObjectScopeNode
implements ScopeNode {
    private final ModifierConverter converter = new ModifierConverter();
    private final ScopeNodeBuilder builder;
    private final List<ScopeNode> nodes = new ArrayList<ScopeNode>();
    private final Object object;
    private final String path;
    private final String name;
    private final int depth;

    public ObjectScopeNode(ScopeNodeBuilder builder, Object object, String path, String name, int depth) {
        this.builder = builder;
        this.object = object;
        this.depth = depth;
        this.path = path;
        this.name = name;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<ScopeNode> getNodes() {
        Class<?> type;
        Map<String, Field> fields;
        Set<String> names;
        if (this.nodes.isEmpty() && !(names = (fields = this.getFields(type = this.object.getClass())).keySet()).isEmpty()) {
            for (String name : names) {
                try {
                    Field field = fields.get(name);
                    Object value = field.get(this.object);
                    int modifiers = this.converter.convert(field);
                    ScopeNode node = this.builder.createNode(this.path + "." + name, name, value, modifiers, this.depth);
                    if (node == null) continue;
                    this.nodes.add(node);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.nodes;
    }

    private Map<String, Field> getFields(Class type) {
        HashMap<String, Field> accessors = new HashMap<String, Field>();
        while (type != Object.class) {
            Field[] fields = type.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                String name = field.getName();
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) continue;
                field.setAccessible(true);
                accessors.put(name, field);
            }
            type = type.getSuperclass();
        }
        return accessors;
    }
}

