/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.debug;

import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.core.trace.TraceType;
import org.snapscript.studio.agent.ProcessMode;
import org.snapscript.studio.agent.debug.ScopeContext;
import org.snapscript.studio.agent.debug.ScopeExtractor;
import org.snapscript.studio.agent.debug.ScopeVariableTree;
import org.snapscript.studio.agent.debug.ThreadStatus;
import org.snapscript.studio.agent.event.ScopeEvent;

public class ScopeEventBuilder {
    private final ScopeVariableTree blank;
    private final ScopeExtractor extractor;
    private final AtomicInteger counter = new AtomicInteger();
    private final TraceType type;
    private final String process;
    private final String resource;
    private final String thread;
    private final String stack;
    private final int line;
    private final int depth;
    private final int count;

    public ScopeEventBuilder(ScopeExtractor extractor, TraceType type, String process, String thread, String stack, String resource, int line, int depth, int count) {
        this.blank = ScopeVariableTree.EMPTY;
        this.extractor = extractor;
        this.process = process;
        this.thread = thread;
        this.resource = resource;
        this.stack = stack;
        this.line = line;
        this.depth = depth;
        this.count = count;
        this.type = type;
    }

    public ScopeEvent suspendEvent(ProcessMode mode) {
        boolean remote = mode.isRemoteAttachment();
        int count = this.counter.getAndIncrement();
        ScopeContext context = this.extractor.build(remote, count > 0 || !remote);
        ScopeVariableTree variables = context.getTree();
        String source = context.getSource();
        String name = this.type.name();
        return new ScopeEvent.Builder(this.process).withVariables(variables).withThread(this.thread).withStack(this.stack).withInstruction(name).withStatus(ThreadStatus.SUSPENDED).withResource(this.resource).withSource(source).withLine(this.line).withDepth(this.depth).withKey(count).build();
    }

    public ScopeEvent resumeEvent(ProcessMode mode) {
        String name = this.type.name();
        return new ScopeEvent.Builder(this.process).withVariables(this.blank).withThread(this.thread).withStack(this.stack).withInstruction(name).withStatus(ThreadStatus.RUNNING).withResource(this.resource).withLine(this.line).withDepth(this.depth).withKey(this.count).build();
    }
}

