/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.debug;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.scope.index.Local;
import org.snapscript.core.scope.index.Table;
import org.snapscript.core.variable.Value;
import org.snapscript.studio.agent.debug.ScopeNode;
import org.snapscript.studio.agent.debug.ScopeNodeBuilder;

public class ScopeNodeTree
implements ScopeNode {
    private final ScopeNodeBuilder builder;
    private final List<ScopeNode> nodes = new ArrayList<ScopeNode>();
    private final Scope scope;

    public ScopeNodeTree(ScopeNodeBuilder builder, Scope scope) {
        this.builder = builder;
        this.scope = scope;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    public List<ScopeNode> getNodes() {
        if (this.nodes.isEmpty()) {
            State state = this.scope.getState();
            Table table = this.scope.getTable();
            Iterator names = state.iterator();
            Iterator locals = table.iterator();
            if (names.hasNext() || locals.hasNext()) {
                int modifiers;
                ScopeNode node;
                Object object;
                HashSet<String> done = new HashSet<String>();
                while (locals.hasNext()) {
                    Local local = (Local)locals.next();
                    if (local == null) continue;
                    String name = local.getName();
                    object = local.getValue();
                    if (!done.add(name) || (node = this.builder.createNode(name, name, object, modifiers = local.getModifiers(), 0)) == null) continue;
                    this.nodes.add(node);
                }
                while (names.hasNext()) {
                    String name = (String)names.next();
                    Value value = state.getValue(name);
                    if (value == null || !done.add(name) || (node = this.builder.createNode(name, name, object = value.getValue(), modifiers = value.getModifiers(), 0)) == null) continue;
                    this.nodes.add(node);
                }
            }
        }
        return this.nodes;
    }
}

