/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.debug;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.core.Context;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceType;
import org.snapscript.studio.agent.ProcessMode;
import org.snapscript.studio.agent.debug.BreakpointMatcher;
import org.snapscript.studio.agent.debug.ResourceExtractor;
import org.snapscript.studio.agent.debug.ResumeListener;
import org.snapscript.studio.agent.debug.ResumeType;
import org.snapscript.studio.agent.debug.ScopeBrowser;
import org.snapscript.studio.agent.debug.ScopeEventBuilder;
import org.snapscript.studio.agent.debug.ScopeExtractor;
import org.snapscript.studio.agent.debug.SuspendController;
import org.snapscript.studio.agent.debug.ThreadProgress;
import org.snapscript.studio.agent.debug.ThreadProgressLocal;
import org.snapscript.studio.agent.debug.ThreadStackGenerator;
import org.snapscript.studio.agent.debug.TraceAdapter;
import org.snapscript.studio.agent.event.ProcessEventChannel;
import org.snapscript.studio.agent.event.ScopeEvent;

public class SuspendInterceptor
extends TraceAdapter {
    private static final String THREAD_NAME = "%s: %s@%s";
    private final ProcessEventChannel channel;
    private final ThreadProgressLocal monitor;
    private final AtomicInteger counter;
    private final SuspendController latch;
    private final ProcessMode mode;
    private final String process;

    public SuspendInterceptor(ProcessEventChannel channel, BreakpointMatcher matcher, SuspendController latch, ProcessMode mode, String process) {
        this.monitor = new ThreadProgressLocal(matcher);
        this.counter = new AtomicInteger();
        this.channel = channel;
        this.process = process;
        this.latch = latch;
        this.mode = mode;
    }

    @Override
    public void traceBefore(Scope scope, Trace trace) {
        ThreadProgress progress = (ThreadProgress)this.monitor.get();
        TraceType type = trace.getType();
        Module module = scope.getModule();
        Path source = trace.getPath();
        String resource = source.getPath();
        int line = trace.getLine();
        if (progress.isSuspendBefore(trace)) {
            try {
                String thread = Thread.currentThread().getName();
                int count = this.counter.getAndIncrement();
                int depth = progress.currentDepth();
                Context context = module.getContext();
                ThreadStack stack = context.getStack();
                String path = ResourceExtractor.extractResource(resource);
                ThreadStackGenerator generator = new ThreadStackGenerator(stack);
                String threads = generator.generate();
                String threadName = String.format(THREAD_NAME, ScopeNotifier.class.getSimpleName(), path, line);
                ScopeExtractor extractor = new ScopeExtractor(context, scope, path);
                ScopeEventBuilder builder = new ScopeEventBuilder(extractor, type, this.process, thread, threads, path, line, depth, count);
                ScopeNotifier notifier = new ScopeNotifier(builder, this.mode, threadName);
                ScopeEvent suspend = builder.suspendEvent(this.mode);
                ScopeEvent resume = builder.resumeEvent(this.mode);
                progress.clear();
                this.channel.send(suspend);
                notifier.start();
                this.suspend(notifier, extractor, resource, line);
                this.channel.send(resume);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        progress.beforeInstruction(type);
    }

    @Override
    public void traceAfter(Scope scope, Trace trace) {
        ThreadProgress progress = (ThreadProgress)this.monitor.get();
        TraceType type = trace.getType();
        Module module = scope.getModule();
        Path source = trace.getPath();
        String resource = source.getPath();
        int line = trace.getLine();
        if (progress.isSuspendAfter(trace)) {
            try {
                String thread = Thread.currentThread().getName();
                int count = this.counter.getAndIncrement();
                int depth = progress.currentDepth();
                Context context = module.getContext();
                ThreadStack stack = context.getStack();
                String path = ResourceExtractor.extractResource(resource);
                ThreadStackGenerator generator = new ThreadStackGenerator(stack);
                String threads = generator.generate();
                String threadName = String.format(THREAD_NAME, ScopeNotifier.class.getSimpleName(), path, line);
                ScopeExtractor extractor = new ScopeExtractor(context, scope, path);
                ScopeEventBuilder builder = new ScopeEventBuilder(extractor, type, this.process, thread, threads, path, line, depth, count);
                ScopeNotifier notifier = new ScopeNotifier(builder, this.mode, threadName);
                ScopeEvent suspend = builder.suspendEvent(this.mode);
                ScopeEvent resume = builder.resumeEvent(this.mode);
                progress.clear();
                this.channel.send(suspend);
                notifier.start();
                this.suspend(notifier, extractor, resource, line);
                this.channel.send(resume);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        progress.afterInstruction(type);
    }

    private void suspend(ScopeNotifier notifier, ScopeBrowser browser, String resource, int line) {
        ResumeType type = this.latch.suspend(notifier, browser);
        ThreadProgress step = (ThreadProgress)this.monitor.get();
        step.resume(type);
    }

    private class ScopeNotifier
    extends Thread
    implements ResumeListener {
        private final ScopeEventBuilder builder;
        private final AtomicBoolean active = new AtomicBoolean(true);
        private final ProcessMode mode;

        public ScopeNotifier(ScopeEventBuilder builder, ProcessMode mode, String name) {
            this.builder = builder;
            this.setName(name);
            this.mode = mode;
        }

        @Override
        public void run() {
            try {
                while (this.active.get()) {
                    Thread.sleep(400L);
                    if (!this.active.get()) continue;
                    ScopeEvent event = this.builder.suspendEvent(this.mode);
                    SuspendInterceptor.this.channel.send(event);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.active.set(false);
            }
        }

        @Override
        public void resume(String thread) {
            this.active.set(false);
        }
    }
}

