/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.debug;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.module.Path;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceType;
import org.snapscript.studio.agent.debug.BreakpointMatcher;
import org.snapscript.studio.agent.debug.ResumeType;

public class ThreadProgress {
    private final AtomicReference<ResumeType> resume = new AtomicReference();
    private final AtomicReference<Trace> current = new AtomicReference();
    private final BreakpointMatcher matcher;
    private final AtomicInteger match = new AtomicInteger();
    private final AtomicInteger depth = new AtomicInteger();

    public ThreadProgress(BreakpointMatcher matcher) {
        this.matcher = matcher;
    }

    public int currentDepth() {
        return this.depth.get();
    }

    public void beforeInstruction(TraceType trace) {
        if (trace == TraceType.CONSTRUCT) {
            this.depth.getAndIncrement();
        } else if (trace == TraceType.INVOKE) {
            this.depth.getAndIncrement();
        } else if (trace == TraceType.NATIVE) {
            this.depth.getAndIncrement();
        }
    }

    public void afterInstruction(TraceType trace) {
        if (trace == TraceType.CONSTRUCT) {
            this.depth.getAndDecrement();
        } else if (trace == TraceType.INVOKE) {
            this.depth.getAndDecrement();
        } else if (trace == TraceType.NATIVE) {
            this.depth.getAndDecrement();
        }
    }

    public void resume(ResumeType type) {
        int value = this.depth.get();
        if (type == ResumeType.RUN) {
            this.match.set(-1);
        } else if (type == ResumeType.STEP_IN) {
            this.match.set(value + 1);
        } else if (type == ResumeType.STEP_OUT) {
            this.match.set(value - 1);
        } else if (type == ResumeType.STEP_OVER) {
            this.match.set(value);
        }
        this.resume.set(type);
    }

    public boolean isSuspendBefore(Trace trace) {
        if (this.isMatchBefore(trace)) {
            this.current.set(trace);
            return true;
        }
        return false;
    }

    private boolean isMatchBefore(Trace trace) {
        int line;
        TraceType traceType = trace.getType();
        Path path = trace.getPath();
        String resource = path.getPath();
        if (this.matcher.isBreakpoint(resource, line = trace.getLine())) {
            return true;
        }
        if (traceType == TraceType.DEBUG) {
            return true;
        }
        if (traceType == TraceType.NORMAL) {
            ResumeType resumeType = this.resume.get();
            int require = this.match.get();
            int actual = this.depth.get();
            if (resumeType != null) {
                if (resumeType == ResumeType.RUN) {
                    return false;
                }
                if (resumeType == ResumeType.STEP_IN) {
                    return true;
                }
                if (resumeType == ResumeType.STEP_OUT) {
                    return actual <= require;
                }
                if (resumeType == ResumeType.STEP_OVER) {
                    return actual <= require;
                }
                return require == actual;
            }
        }
        return false;
    }

    public boolean isSuspendAfter(Trace trace) {
        if (this.isMatchAfter(trace) && this.isLineChange(trace)) {
            this.current.set(null);
            return true;
        }
        return false;
    }

    private boolean isMatchAfter(Trace trace) {
        TraceType traceType = trace.getType();
        if (traceType == TraceType.NORMAL) {
            ResumeType resumeType = this.resume.get();
            int require = this.match.get();
            int actual = this.depth.get();
            if (resumeType != null) {
                if (resumeType == ResumeType.RUN) {
                    return false;
                }
                if (resumeType == ResumeType.STEP_IN) {
                    return true;
                }
                if (resumeType == ResumeType.STEP_OUT) {
                    return actual <= require;
                }
                if (resumeType == ResumeType.STEP_OVER) {
                    return actual <= require;
                }
                return require == actual;
            }
        }
        return false;
    }

    private boolean isLineChange(Trace trace) {
        Trace previous = this.current.get();
        if (previous != null) {
            int previousLine = previous.getLine();
            int thisLine = trace.getLine();
            if (thisLine > 0) {
                Path previousPath = previous.getPath();
                Path thisPath = trace.getPath();
                if (previousLine != thisLine) {
                    return true;
                }
                String previousResource = previousPath.getPath();
                String thisResource = thisPath.getPath();
                if (!thisResource.equals(previousResource)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void clear() {
        this.resume.set(null);
        this.match.set(-1);
    }
}

