/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.debug;

import org.snapscript.core.Context;
import org.snapscript.core.scope.instance.Instance;
import org.snapscript.core.type.Type;
import org.snapscript.studio.agent.debug.ArrayStringBuilder;
import org.snapscript.studio.agent.debug.ValueData;

public class ValueDataBuilder {
    private static final int MAX_LENGTH = 1024;
    private final ArrayStringBuilder builder;
    private final int limit;

    public ValueDataBuilder(Context context) {
        this(context, 1024);
    }

    public ValueDataBuilder(Context context, int limit) {
        this.builder = new ArrayStringBuilder(context, limit);
        this.limit = limit;
    }

    public ValueData createNull(String key, Object value, int modifiers, int depth) {
        return new ValueData(key, "", "null", "null", false, modifiers, depth);
    }

    public ValueData createArray(String key, Object value, int modifiers, int depth) {
        StringBuilder dimensions = new StringBuilder();
        Class<?> type = value.getClass();
        Class<?> entry = type.getComponentType();
        String text = "";
        text = type == byte[].class ? this.builder.toString((byte[])value) : (type == int[].class ? this.builder.toString((int[])value) : (type == long[].class ? this.builder.toString((long[])value) : (type == double[].class ? this.builder.toString((double[])value) : (type == float[].class ? this.builder.toString((float[])value) : (type == short[].class ? this.builder.toString((short[])value) : (type == char[].class ? this.builder.toString((char[])value) : (type == boolean[].class ? this.builder.toString((boolean[])value) : this.builder.toString((Object[])value))))))));
        while (entry != null) {
            dimensions.append("[]");
            type = entry;
            entry = type.getComponentType();
        }
        String name = type.getSimpleName();
        int length = text.length();
        if (length > this.limit) {
            text = text.substring(0, this.limit) + "...";
        }
        return new ValueData(key, name + dimensions, "", text, true, modifiers, depth);
    }

    public ValueData createObject(String key, Object value, int modifiers, int depth) {
        Class<?> type = value.getClass();
        String name = type.getSimpleName();
        String text = String.valueOf(value);
        int length = text.length();
        if (length > this.limit) {
            text = text.substring(0, this.limit) + "...";
        }
        return new ValueData(key, name, "", text, true, modifiers, depth);
    }

    public ValueData createPrimitive(String key, Object value, int modifiers, int depth) {
        Class<?> type = value.getClass();
        String name = type.getSimpleName();
        String text = String.valueOf(value);
        int length = text.length();
        if (length > this.limit) {
            text = text.substring(0, this.limit) + "...";
        }
        return new ValueData(key, name, text, text, false, modifiers, depth);
    }

    public ValueData createScope(String key, Object value, int modifiers, int depth) {
        Instance instance = (Instance)value;
        Type type = instance.getType();
        String name = type.getName();
        return new ValueData(key, name, "", "", true, modifiers, depth);
    }
}

