/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.event;

import org.snapscript.studio.agent.ProcessMode;
import org.snapscript.studio.agent.core.ExecuteStatus;
import org.snapscript.studio.agent.event.StatusEvent;

public class BeginEvent
implements StatusEvent {
    private final ExecuteStatus status;
    private final ProcessMode mode;
    private final String resource;
    private final String process;
    private final String project;
    private final String system;
    private final long totalMemory;
    private final long usedMemory;
    private final int threads;
    private final long duration;

    private BeginEvent(Builder builder) {
        this.totalMemory = builder.totalMemory;
        this.usedMemory = builder.usedMemory;
        this.threads = builder.threads;
        this.resource = builder.resource;
        this.process = builder.process;
        this.project = builder.project;
        this.status = builder.status;
        this.system = builder.system;
        this.duration = builder.duration;
        this.mode = builder.mode;
    }

    @Override
    public String getProcess() {
        return this.process;
    }

    public ProcessMode getMode() {
        return this.mode;
    }

    @Override
    public ExecuteStatus getStatus() {
        return this.status;
    }

    @Override
    public String getProject() {
        return this.project;
    }

    @Override
    public String getSystem() {
        return this.system;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public long getUsedMemory() {
        return this.usedMemory;
    }

    @Override
    public long getTotalMemory() {
        return this.totalMemory;
    }

    @Override
    public int getThreads() {
        return this.threads;
    }

    public long getDuration() {
        return this.duration;
    }

    public static class Builder
    implements StatusEvent.Builder<BeginEvent> {
        private ExecuteStatus status;
        private ProcessMode mode;
        private String resource;
        private String process;
        private String project;
        private String system;
        private long totalMemory;
        private long usedMemory;
        private int threads;
        private long duration;

        public Builder(String process) {
            this.process = process;
        }

        public Builder withProject(String project) {
            this.project = project;
            return this;
        }

        public Builder withStatus(ExecuteStatus status) {
            this.status = status;
            return this;
        }

        public Builder withResource(String resource) {
            this.resource = resource;
            return this;
        }

        public Builder withSystem(String system) {
            this.system = system;
            return this;
        }

        public Builder withThreads(int threads) {
            this.threads = threads;
            return this;
        }

        public Builder withTotalMemory(long totalMemory) {
            this.totalMemory = totalMemory;
            return this;
        }

        public Builder withUsedMemory(long usedMemory) {
            this.usedMemory = usedMemory;
            return this;
        }

        public Builder withMode(ProcessMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public BeginEvent build() {
            return new BeginEvent(this);
        }
    }
}

