/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.event;

import org.snapscript.studio.agent.core.ExecuteStatus;
import org.snapscript.studio.agent.event.StatusEvent;

public class PongEvent
implements StatusEvent {
    private final ExecuteStatus status;
    private final String project;
    private final String process;
    private final String resource;
    private final String system;
    private final long totalMemory;
    private final long usedMemory;
    private final int threads;

    protected PongEvent(Builder<? extends PongEvent> builder) {
        this.totalMemory = ((Builder)builder).totalMemory;
        this.usedMemory = ((Builder)builder).usedMemory;
        this.threads = ((Builder)builder).threads;
        this.resource = ((Builder)builder).resource;
        this.process = ((Builder)builder).process;
        this.project = ((Builder)builder).project;
        this.status = ((Builder)builder).status;
        this.system = ((Builder)builder).system;
    }

    @Override
    public String getProcess() {
        return this.process;
    }

    @Override
    public ExecuteStatus getStatus() {
        return this.status;
    }

    @Override
    public String getProject() {
        return this.project;
    }

    @Override
    public String getSystem() {
        return this.system;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public long getUsedMemory() {
        return this.usedMemory;
    }

    @Override
    public long getTotalMemory() {
        return this.totalMemory;
    }

    @Override
    public int getThreads() {
        return this.threads;
    }

    public static class Builder<T extends PongEvent>
    implements StatusEvent.Builder<T> {
        private ExecuteStatus status;
        private String project;
        private String process;
        private String resource;
        private String system;
        private long totalMemory;
        private long usedMemory;
        private int threads;

        public Builder(String process) {
            this.process = process;
        }

        @Override
        public Builder<T> withProject(String project) {
            this.project = project;
            return this;
        }

        @Override
        public Builder<T> withStatus(ExecuteStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public Builder<T> withResource(String resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public Builder<T> withSystem(String system) {
            this.system = system;
            return this;
        }

        @Override
        public Builder<T> withThreads(int threads) {
            this.threads = threads;
            return this;
        }

        @Override
        public Builder<T> withTotalMemory(long totalMemory) {
            this.totalMemory = totalMemory;
            return this;
        }

        @Override
        public Builder<T> withUsedMemory(long usedMemory) {
            this.usedMemory = usedMemory;
            return this;
        }

        @Override
        public T build() {
            return (T)new PongEvent(this);
        }
    }
}

