/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.snapscript.studio.agent.core.ExecuteStatus;
import org.snapscript.studio.agent.event.MessageEnvelope;
import org.snapscript.studio.agent.event.PongEvent;
import org.snapscript.studio.agent.event.ProcessEventMarshaller;
import org.snapscript.studio.agent.event.ProcessEventType;

public class PongEventMarshaller<T extends PongEvent>
implements ProcessEventMarshaller<T> {
    private final int code;

    public PongEventMarshaller() {
        this(ProcessEventType.PONG.code);
    }

    public PongEventMarshaller(int code) {
        this.code = code;
    }

    @Override
    public T fromMessage(MessageEnvelope message) throws IOException {
        byte[] array = message.getData();
        int length = message.getLength();
        int offset = message.getOffset();
        ByteArrayInputStream buffer = new ByteArrayInputStream(array, offset, length);
        DataInputStream input = new DataInputStream(buffer);
        String process = input.readUTF();
        String system = input.readUTF();
        String status = input.readUTF();
        if (input.readBoolean()) {
            String project = input.readUTF();
            String resource = input.readUTF();
            long totalMemory = input.readLong();
            long usedMemory = input.readLong();
            int threads = input.readInt();
            return (T)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)this.getBuilder(process).withSystem(system)).withProject(project)).withResource(resource)).withStatus(ExecuteStatus.resolveStatus(status))).withTotalMemory(totalMemory)).withUsedMemory(usedMemory)).withThreads(threads)).build();
        }
        return (T)((PongEvent.Builder)((PongEvent.Builder)this.getBuilder(process).withSystem(system)).withStatus(ExecuteStatus.resolveStatus(status))).build();
    }

    @Override
    public MessageEnvelope toMessage(T event) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(buffer);
        String process = ((PongEvent)event).getProcess();
        ExecuteStatus status = ((PongEvent)event).getStatus();
        String resource = ((PongEvent)event).getResource();
        String project = ((PongEvent)event).getProject();
        String system = ((PongEvent)event).getSystem();
        long totalMemory = ((PongEvent)event).getTotalMemory();
        long usedMemory = ((PongEvent)event).getUsedMemory();
        int threads = ((PongEvent)event).getThreads();
        output.writeUTF(process);
        output.writeUTF(system);
        output.writeUTF(status.name());
        if (status.isStarted()) {
            output.writeBoolean(true);
            output.writeUTF(project);
            output.writeUTF(resource);
            output.writeLong(totalMemory);
            output.writeLong(usedMemory);
            output.writeInt(threads);
        } else {
            output.writeBoolean(false);
        }
        output.flush();
        byte[] array = buffer.toByteArray();
        return new MessageEnvelope(this.code, array, 0, array.length);
    }

    protected PongEvent.Builder getBuilder(String process) {
        return new PongEvent.Builder(process);
    }
}

