/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.event;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.snapscript.studio.agent.event.MessageEnvelope;
import org.snapscript.studio.agent.event.MessageEnvelopeWriter;
import org.snapscript.studio.agent.event.ProcessEvent;
import org.snapscript.studio.agent.event.ProcessEventMarshaller;
import org.snapscript.studio.agent.event.ProcessEventType;
import org.snapscript.studio.agent.log.TraceLogger;

public class ProcessEventProducer {
    private final Map<Class, ProcessEventMarshaller> marshallers = new ConcurrentHashMap<Class, ProcessEventMarshaller>();
    private final MessageEnvelopeWriter writer;
    private final TraceLogger logger;
    private final Closeable closeable;
    private final Executor executor;

    public ProcessEventProducer(TraceLogger logger, OutputStream stream, Closeable closeable, Executor executor) {
        this.writer = new MessageEnvelopeWriter(stream, closeable);
        this.closeable = closeable;
        this.executor = executor;
        this.logger = logger;
    }

    public void produce(ProcessEvent event) throws Exception {
        SendTask task = new SendTask(event);
        task.call();
    }

    public Future<Boolean> produceAsync(ProcessEvent event) throws Exception {
        SendTask task = new SendTask(event);
        FutureTask<Boolean> future = new FutureTask<Boolean>(task);
        this.executor.execute(future);
        return future;
    }

    public void close(String reason) throws Exception {
        CloseTask task = new CloseTask(reason);
        FutureTask<Boolean> future = new FutureTask<Boolean>(task);
        this.executor.execute(future);
        future.get();
    }

    private class SendTask
    implements Callable<Boolean> {
        private final ProcessEvent event;

        public SendTask(ProcessEvent event) {
            this.event = event;
        }

        @Override
        public Boolean call() throws Exception {
            Class<?> type = this.event.getClass();
            try {
                if (!ProcessEventProducer.this.marshallers.containsKey(type)) {
                    ProcessEventType[] events;
                    for (ProcessEventType event : events = ProcessEventType.values()) {
                        ProcessEventMarshaller marshaller = event.marshaller.newInstance();
                        ProcessEventProducer.this.marshallers.put(event.event, marshaller);
                    }
                }
                ProcessEventMarshaller marshaller = (ProcessEventMarshaller)ProcessEventProducer.this.marshallers.get(type);
                MessageEnvelope message = marshaller.toMessage(this.event);
                ProcessEventProducer.this.writer.write(message);
                return true;
            }
            catch (Exception e) {
                ProcessEventProducer.this.logger.info("Error sending event", e);
                ProcessEventProducer.this.closeable.close();
                throw new IllegalStateException("Error writing message", e);
            }
        }
    }

    private class CloseTask
    implements Callable<Boolean> {
        private final Exception cause;
        private final String reason;

        public CloseTask(String reason) {
            this.cause = new Exception("Closing connection: " + reason);
            this.reason = reason;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                ProcessEventProducer.this.logger.info("Closing connection: " + this.reason);
                ProcessEventProducer.this.closeable.close();
                ProcessEventProducer.this.writer.close();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not close writer: " + this.reason);
            }
            return true;
        }
    }
}

