/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.event;

import org.snapscript.studio.agent.event.ProcessEvent;

public class ScriptErrorEvent
implements ProcessEvent {
    private final String description;
    private final String resource;
    private final String process;
    private final int line;

    private ScriptErrorEvent(Builder builder) {
        this.description = builder.description;
        this.process = builder.process;
        this.resource = builder.resource;
        this.line = builder.line;
    }

    @Override
    public String getProcess() {
        return this.process;
    }

    public String getDescription() {
        return this.description;
    }

    public String getResource() {
        return this.resource;
    }

    public int getLine() {
        return this.line;
    }

    public static class Builder {
        private String description;
        private String resource;
        private String process;
        private int line;

        public Builder(String process) {
            this.process = process;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withResource(String resource) {
            this.resource = resource;
            return this;
        }

        public Builder withProcess(String process) {
            this.process = process;
            return this;
        }

        public Builder withLine(int line) {
            this.line = line;
            return this;
        }

        public ScriptErrorEvent build() {
            return new ScriptErrorEvent(this);
        }
    }
}

