/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.local;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.snapscript.core.module.Path;
import org.snapscript.studio.agent.cli.CommandLine;
import org.snapscript.studio.agent.cli.CommandOption;
import org.snapscript.studio.agent.local.LocalOption;

public class LocalCommandLine {
    private final CommandLine line;

    public LocalCommandLine(CommandLine line) {
        this.line = line;
    }

    public List<? extends CommandOption> getOptions() {
        return this.line.getOptions();
    }

    public boolean isDebug() {
        return (Boolean)this.line.getValue(LocalOption.VERBOSE.name);
    }

    public boolean isCheck() {
        return (Boolean)this.line.getValue(LocalOption.CHECK.name);
    }

    public boolean isWait() {
        return (Boolean)this.line.getValue(LocalOption.WAIT.name);
    }

    public Integer getPort() {
        return (Integer)this.line.getValue(LocalOption.PORT.name);
    }

    public File getDirectory() {
        return (File)this.line.getValue(LocalOption.DIRECTORY.name);
    }

    public List<File> getClasspath() {
        return (List)this.line.getValue(LocalOption.CLASSPATH.name);
    }

    public Path getScript() {
        return (Path)this.line.getValue(LocalOption.SCRIPT.name);
    }

    public String getEvaluation() {
        return (String)this.line.getValue(LocalOption.EXPRESSION.name);
    }

    public URI getURI() {
        return (URI)this.line.getValue(LocalOption.URL.name);
    }

    public String getSystem() {
        return System.getProperty("os.name", "unknown");
    }

    public boolean isVersion() {
        return (Boolean)this.line.getValue(LocalOption.VERSION.name);
    }

    public String[] getArguments() {
        return this.line.getArguments();
    }
}

