/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.local;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import org.snapscript.core.module.Path;
import org.snapscript.studio.agent.cli.CommandLineBuilder;
import org.snapscript.studio.agent.cli.CommandOption;

public enum LocalOption implements CommandOption
{
    DIRECTORY("d", "directory", "specify directory to execute in", ".+", File.class, "."),
    URL("u", "url", "specify a URL to download sources from", ".+", URI.class),
    SCRIPT("s", "script", "script to execute", ".+", Path.class),
    EXPRESSION("e", "expression", "expression to evaluate", ".+", String.class),
    CLASSPATH("cp", "classpath", "optional classpath file", ".+", File[].class),
    VERBOSE("v", "verbose", "enable verbose logging", "(true|false)", Boolean.class, false),
    CHECK("c", "check", "compile script only", "(true|false)", Boolean.class, false),
    PORT("p", "port", "debug port", "\\d+", Integer.class),
    WAIT("w", "wait", "wait for debugger", "(true|false)", Boolean.class, false),
    VERSION("ve", "version", "implementation version", ".+", Boolean.class, false);

    public final Pattern pattern;
    public final String description;
    public final Object value;
    public final String name;
    public final String code;
    public final Class type;

    private LocalOption(String code, String name, String description, String pattern, Class type) {
        this(code, name, description, pattern, type, null);
    }

    private LocalOption(String code, String name, String description, String pattern, Class type, Object value) {
        this.pattern = Pattern.compile(pattern);
        this.description = description;
        this.value = value;
        this.name = name;
        this.code = code;
        this.type = type;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getDefault() {
        return this.value;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    public static CommandLineBuilder getBuilder() {
        LocalOption[] options = LocalOption.values();
        if (options.length > 0) {
            ArrayList<LocalOption> list = new ArrayList<LocalOption>();
            CommandLineBuilder parser = new CommandLineBuilder(list);
            for (LocalOption option : options) {
                list.add(option);
            }
            return parser;
        }
        return new CommandLineBuilder(Collections.EMPTY_LIST);
    }
}

