/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.local;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.common.thread.ThreadBuilder;
import org.snapscript.core.module.Path;
import org.snapscript.studio.agent.ProcessAgent;
import org.snapscript.studio.agent.ProcessClient;
import org.snapscript.studio.agent.ProcessContext;
import org.snapscript.studio.agent.local.LocalMessageConsumer;
import org.snapscript.studio.agent.local.message.AttachRequest;
import org.snapscript.studio.agent.local.message.DetachRequest;
import org.snapscript.studio.agent.log.LogLevel;

public class LocalProcessController {
    private final AtomicReference<ProcessClient> reference;
    private final ConnectLauncher launcher;
    private final ProcessContext context;
    private final AtomicBoolean active;
    private final CountDownLatch latch;
    private final Path script;

    public LocalProcessController(ProcessContext context, CountDownLatch latch, Path script, int port) {
        this.launcher = new ConnectLauncher(context, this, port);
        this.reference = new AtomicReference();
        this.active = new AtomicBoolean();
        this.context = context;
        this.script = script;
        this.latch = latch;
    }

    public String attachRequest(AttachRequest request) {
        String project = request.getProject();
        URI root = request.getTarget();
        String path = this.script.getPath();
        if (!this.isAttached()) {
            try {
                ProcessAgent agent = new ProcessAgent(this.context, LogLevel.INFO);
                ProcessClient client = agent.start(root, this.launcher);
                System.err.println("Debug agent attached to " + root);
                this.reference.set(client);
                client.attachProcess(project, path);
                this.latch.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.context.getProcess();
    }

    public String detachRequest(DetachRequest request) {
        ProcessClient client = this.reference.getAndSet(null);
        try {
            if (client != null) {
                System.err.println("Debug agent detached");
                client.detachClient();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.context.getProcess();
    }

    public void reset() {
        ProcessClient client = this.reference.getAndSet(null);
        try {
            if (client != null) {
                System.err.println("Debug agent detached");
                client.detachClient();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isAttached() {
        return this.reference.get() != null;
    }

    public void start() {
        this.launcher.run();
    }

    private class ConnectAcceptor
    implements Runnable {
        private final LocalMessageConsumer consumer;
        private final int port;

        public ConnectAcceptor(LocalProcessController listener, int port) {
            this.consumer = new LocalMessageConsumer(listener);
            this.port = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ServerSocket listener = new ServerSocket(this.port);
                try {
                    int local = listener.getLocalPort();
                    System.err.println("Debug agent listening on " + local);
                    while (LocalProcessController.this.active.get()) {
                        Socket socket = listener.accept();
                        try {
                            this.consumer.consume(socket);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            socket.close();
                        }
                    }
                }
                finally {
                    listener.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                LocalProcessController.this.active.set(false);
            }
        }
    }

    private class ConnectLauncher
    implements Runnable {
        private final LocalProcessController listener;
        private final ConnectAcceptor acceptor;
        private final ThreadFactory factory;

        public ConnectLauncher(ProcessContext context, LocalProcessController listener, int port) {
            this.acceptor = new ConnectAcceptor(listener, port);
            this.factory = new ThreadBuilder();
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.reset();
            if (LocalProcessController.this.active.compareAndSet(false, true)) {
                Thread thread = this.factory.newThread(this.acceptor);
                thread.start();
            }
        }
    }
}

