/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.local;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.snapscript.compile.Executable;
import org.snapscript.compile.ResourceCompiler;
import org.snapscript.compile.verify.VerifyError;
import org.snapscript.compile.verify.VerifyException;
import org.snapscript.core.ExpressionEvaluator;
import org.snapscript.core.module.FilePathConverter;
import org.snapscript.core.module.Path;
import org.snapscript.core.module.PathConverter;
import org.snapscript.core.scope.MapModel;
import org.snapscript.core.scope.Model;
import org.snapscript.studio.agent.ProcessContext;
import org.snapscript.studio.agent.ProcessMode;
import org.snapscript.studio.agent.cli.CommandLineUsage;
import org.snapscript.studio.agent.cli.CommandOption;
import org.snapscript.studio.agent.local.LocalCommandLine;
import org.snapscript.studio.agent.local.LocalNameGenerator;
import org.snapscript.studio.agent.local.LocalOption;
import org.snapscript.studio.agent.local.LocalProcessController;
import org.snapscript.studio.agent.local.store.LocalStore;
import org.snapscript.studio.agent.local.store.LocalStoreBuilder;

public class LocalProcessExecutor {
    private final LocalStoreBuilder builder = new LocalStoreBuilder();
    private final PathConverter converter = new FilePathConverter();

    public void execute(LocalCommandLine line) throws Exception {
        ProcessContext context = this.createContext(line);
        Model model = this.createModel(line);
        String module = this.createModule(line);
        Executable executable = this.createExecutable(line, context);
        ExpressionEvaluator evaluator = context.getEvaluator();
        String evaluate = line.getEvaluation();
        Path script = line.getScript();
        Integer port = line.getPort();
        try {
            CountDownLatch latch = new CountDownLatch(1);
            if (port != null && script != null) {
                LocalProcessController connector = new LocalProcessController(context, latch, script, port);
                if (!line.isWait()) {
                    latch.countDown();
                }
                connector.start();
            } else {
                latch.countDown();
            }
            if (evaluate != null) {
                if (executable != null) {
                    executable.execute(model, true);
                }
                latch.await();
                evaluator.evaluate(model, evaluate, module);
            } else if (line.isCheck()) {
                executable.execute(model, true);
            } else {
                latch.await();
                executable.execute(model);
            }
        }
        catch (VerifyException cause) {
            List<VerifyError> errors = cause.getErrors();
            for (VerifyError error : errors) {
                System.err.println(error);
                System.err.flush();
            }
        }
    }

    private ProcessContext createContext(LocalCommandLine line) throws Exception {
        List<? extends CommandOption> options = line.getOptions();
        String process = LocalNameGenerator.getProcess();
        LocalStore store = this.builder.create(line);
        String evaluate = line.getEvaluation();
        String system = line.getSystem();
        Path script = line.getScript();
        if (evaluate == null && script == null) {
            String message = String.format("--%s or --%s required", LocalOption.SCRIPT.name, LocalOption.SCRIPT.name);
            CommandLineUsage.usage(options, message);
        }
        try {
            String path = script.getPath();
            store.getInputStream(path);
        }
        catch (Exception cause) {
            String message = cause.getMessage();
            CommandLineUsage.usage(options, message);
        }
        return new ProcessContext(ProcessMode.REMOTE, store, process, system);
    }

    private Executable createExecutable(LocalCommandLine line, ProcessContext context) throws Exception {
        Path script = line.getScript();
        String file = script.getPath();
        ResourceCompiler compiler = context.getCompiler();
        return compiler.compile(file);
    }

    private Model createModel(LocalCommandLine line) throws Exception {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        MapModel model = new MapModel(values);
        String[] arguments = line.getArguments();
        values.put("args", arguments);
        values.put("arguments", arguments);
        return model;
    }

    private String createModule(LocalCommandLine line) throws Exception {
        Path script = line.getScript();
        if (script != null) {
            String file = script.getPath();
            return this.converter.createModule(file);
        }
        return "default";
    }
}

