/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.local.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.snapscript.common.store.ClassPathStore;
import org.snapscript.common.store.NotFoundException;
import org.snapscript.common.store.Store;
import org.snapscript.core.module.FilePathConverter;
import org.snapscript.core.module.Path;
import org.snapscript.core.module.PathConverter;

public class LocalCacheStore
implements Store {
    private static final long EXPIRY = TimeUnit.DAYS.toMillis(1L);
    private final PathConverter converter = new FilePathConverter();
    private final Store classpath = new ClassPathStore();
    private final Store store;
    private final Path script;
    private final URI url;
    private final boolean debug;
    private File temp;

    public LocalCacheStore(Store store, Path script, URI url, boolean debug) throws IOException {
        this.store = store;
        this.script = script;
        this.url = url;
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(String path) {
        CacheInputStream stream = this.getTempInputStream(path);
        if (stream == null) {
            try {
                InputStream remote = this.store.getInputStream(path);
                try {
                    CacheOutputStream output = this.getTempOutputStream(path);
                    if (output != null) {
                        try {
                            byte[] data = new byte[8192];
                            int count = 0;
                            while ((count = remote.read(data)) != -1) {
                                output.write(data, 0, count);
                            }
                            if (this.debug) {
                                String file = output.getFile();
                                System.err.println("Downloaded " + path + " to " + file);
                            }
                            output.close();
                        }
                        finally {
                            remote.close();
                        }
                        return this.getTempInputStream(path);
                    }
                    return this.classpath.getInputStream(path);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not process '" + path + "' from '" + this.url + "'", e);
                }
            }
            catch (NotFoundException e) {
                CacheOutputStream output = this.getTempOutputStream(path);
                if (output != null) {
                    try {
                        ((OutputStream)output).close();
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
                throw e;
            }
        }
        if (this.debug) {
            String file = stream.getFile();
            System.err.println("Loading " + path + " from " + file);
        }
        if (stream != null && stream.isFailure()) {
            throw new NotFoundException("Could not find resource '" + path + "' from '" + this.url + "'");
        }
        return stream;
    }

    @Override
    public OutputStream getOutputStream(String path) {
        return this.store.getOutputStream(path);
    }

    private CacheOutputStream getTempOutputStream(String path) {
        try {
            File file = this.getTempFile(path);
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            return new CacheOutputStream(new FileOutputStream(file), file);
        }
        catch (Exception e) {
            return null;
        }
    }

    private CacheInputStream getTempInputStream(String path) {
        try {
            File file = this.getTempFile(path);
            if (file.exists()) {
                long currentTime;
                long lastModified = System.currentTimeMillis();
                if (lastModified + EXPIRY > (currentTime = System.currentTimeMillis())) {
                    FileInputStream stream = new FileInputStream(file);
                    return new CacheInputStream(stream, file);
                }
                file.delete();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private File getTempFile(String path) {
        if (this.temp == null) {
            String folder;
            String name;
            String directory = System.getProperty("java.io.tmpdir");
            File file = new File(directory, name = this.converter.createModule(folder = this.script.getPath()));
            if (!file.exists()) {
                file.mkdirs();
            }
            this.temp = file;
        }
        return new File(this.temp, path);
    }

    private static class CacheInputStream
    extends FilterInputStream {
        private final File file;

        public CacheInputStream(InputStream stream, File file) {
            super(stream);
            this.file = file;
        }

        public String getFile() {
            try {
                return this.file.getCanonicalPath();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not get file " + this.file);
            }
        }

        public boolean isFailure() {
            return this.file.length() <= 0L;
        }
    }

    private static class CacheOutputStream
    extends FilterOutputStream {
        private final File file;

        public CacheOutputStream(OutputStream stream, File file) {
            super(stream);
            this.file = file;
        }

        public String getFile() {
            try {
                return this.file.getCanonicalPath();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not get file " + this.file);
            }
        }

        public boolean isFailure() {
            return this.file.length() <= 0L;
        }
    }
}

