/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.log;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.common.thread.ThreadBuilder;
import org.snapscript.studio.agent.log.Log;
import org.snapscript.studio.agent.log.LogLevel;

public class AsyncLog
implements Log {
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final int EVENT_LIMIT = 10000;
    private final LogDispatcher dispatcher = new LogDispatcher(10000);
    private final DateFormatter formatter = new DateFormatter("HH:mm:ss");
    private final LogLevel enabled;
    private final Log logger;

    public AsyncLog(Log logger, LogLevel enabled) {
        this.enabled = enabled;
        this.logger = logger;
    }

    @Override
    public void log(LogLevel level, Object message) {
        if (this.enabled.isLevelEnabled(level)) {
            LogEvent event = new LogEvent(level, message, null);
            this.dispatcher.log(event);
        }
    }

    @Override
    public void log(LogLevel level, Object message, Throwable cause) {
        if (this.enabled.isLevelEnabled(level)) {
            LogEvent event = new LogEvent(level, message, cause);
            this.dispatcher.log(event);
        }
    }

    public void stop() {
        this.dispatcher.stop();
    }

    private class LogEvent
    implements Runnable {
        private final LogLevel level;
        private final Throwable cause;
        private final Object message;
        private final Thread thread;
        private final long time = System.currentTimeMillis();

        public LogEvent(LogLevel level, Object message, Throwable cause) {
            this.thread = Thread.currentThread();
            this.message = message;
            this.cause = cause;
            this.level = level;
        }

        @Override
        public void run() {
            String name = this.thread.getName();
            DateFormat format = (DateFormat)AsyncLog.this.formatter.get();
            String date = format.format(this.time);
            if (this.message != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(date);
                builder.append(" [");
                builder.append(name);
                builder.append("] ");
                builder.append(this.message);
                if (this.cause != null) {
                    AsyncLog.this.logger.log(this.level, builder, this.cause);
                } else {
                    AsyncLog.this.logger.log(this.level, builder);
                }
            }
        }
    }

    private class LogDispatcher
    implements Runnable {
        private final BlockingQueue<LogEvent> queue;
        private final ThreadFactory factory = new ThreadBuilder();
        private final AtomicBoolean active;
        private final AtomicBoolean stopped;

        public LogDispatcher(int capacity) {
            this.queue = new ArrayBlockingQueue<LogEvent>(capacity);
            this.active = new AtomicBoolean();
            this.stopped = new AtomicBoolean();
        }

        public void log(LogEvent event) {
            try {
                if (this.active.compareAndSet(false, true)) {
                    Thread thread = this.factory.newThread(this);
                    thread.start();
                }
                this.queue.offer(event, 10000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not log event", e);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void stop() {
            this.stopped.set(true);
        }
    }

    private class DateFormatter
    extends ThreadLocal<DateFormat> {
        private final String format;

        public DateFormatter(String format) {
            this.format = format;
        }

        @Override
        public DateFormat initialValue() {
            return new SimpleDateFormat(this.format);
        }
    }
}

