/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.log;

public enum LogLevel {
    TRACE(0),
    DEBUG(1),
    INFO(2);

    private final int level;

    private LogLevel(int level) {
        this.level = level;
    }

    public boolean isLevelEnabled(LogLevel level) {
        return this.level <= level.level;
    }

    public boolean isTraceEnabled() {
        return this.level <= LogLevel.TRACE.level;
    }

    public boolean isDebugEnabled() {
        return this.level <= LogLevel.DEBUG.level;
    }

    public boolean isInfoEnabled() {
        return this.level <= LogLevel.INFO.level;
    }

    public static LogLevel resolveLevel(String token) {
        if (token != null) {
            LogLevel[] levels;
            String match = token.trim();
            for (LogLevel level : levels = LogLevel.values()) {
                String name = level.name();
                if (!name.equalsIgnoreCase(match)) continue;
                return level;
            }
        }
        return INFO;
    }
}

