/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.log;

import org.snapscript.studio.agent.log.Log;
import org.snapscript.studio.agent.log.LogLevel;
import org.snapscript.studio.agent.log.TraceLogger;

public class LogLogger
implements TraceLogger {
    private final LogLevel level;
    private final Log logger;

    public LogLogger(Log logger, LogLevel level) {
        this.logger = logger;
        this.level = level;
    }

    @Override
    public String getLevel() {
        return this.level.name();
    }

    @Override
    public boolean isTrace() {
        return this.level.isTraceEnabled();
    }

    @Override
    public boolean isDebug() {
        return this.level.isDebugEnabled();
    }

    @Override
    public void trace(String message) {
        if (this.level.isTraceEnabled()) {
            this.logger.log(LogLevel.TRACE, message);
        }
    }

    @Override
    public void trace(String message, Throwable cause) {
        if (this.level.isTraceEnabled()) {
            this.logger.log(LogLevel.TRACE, message, cause);
        }
    }

    @Override
    public void debug(String message) {
        if (this.level.isDebugEnabled()) {
            this.logger.log(LogLevel.DEBUG, message);
        }
    }

    @Override
    public void debug(String message, Throwable cause) {
        if (this.level.isDebugEnabled()) {
            this.logger.log(LogLevel.DEBUG, message, cause);
        }
    }

    @Override
    public void info(String message) {
        if (this.level.isInfoEnabled()) {
            this.logger.log(LogLevel.INFO, message);
        }
    }

    @Override
    public void info(String message, Throwable cause) {
        if (this.level.isInfoEnabled()) {
            this.logger.log(LogLevel.INFO, message, cause);
        }
    }
}

